% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_concepts_by_letter.R
\name{get_concepts_by_letter}
\alias{get_concepts_by_letter}
\title{Get concepts starting with a specific letter in the alphabetical index for a given vocabulary}
\usage{
get_concepts_by_letter(vocid, letter, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{letter}{The initial letter, or "0-9" for numeric or "!*" for special character labels.}

\item{lang}{The language of labels, e.g., "en" or "fi". Optional.}
}
\value{
A tibble containing concepts with labels starting with the given letter.
}
\description{
Get concepts starting with a specific letter in the alphabetical index for a given vocabulary
}
\examples{
result <- get_concepts_by_letter(vocid = "yso", letter = "A", lang = "fi")
print(result)
}
