% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plot_cdf}
\alias{plot_cdf}
\title{Plot CDF for the Probability of a Distribution}
\usage{
plot_cdf(
  cdf,
  param_list,
  xlim = c(0, 10),
  ylim = c(0, 1),
  n = 500,
  main = "Custom CDF Plot",
  xlab = "x",
  ylab = "CDF",
  colors = NULL,
  shade_colors = NULL,
  lwd = 3,
  lty = 2,
  grid = TRUE,
  grid_lty = 3,
  grid_col = "gray80",
  grid_lwd = 1
)
}
\arguments{
\item{cdf}{Function that computes the CDF. Must accept x as the first argument.}

\item{param_list}{A list of parameter lists. Each element is a named list of parameters for \code{cdf}.}

\item{xlim}{Numeric vector of length 2, specifying the x-axis limits. Default is c(0, 10).}

\item{ylim}{Numeric vector of length 2, specifying the y-axis limits. Default is c(0, 1).}

\item{n}{Number of points to evaluate on the x-axis. Default is 500.}

\item{main}{Title of the plot. Default is "Custom CDF Plot".}

\item{xlab}{Label for the x-axis. Default is "x".}

\item{ylab}{Label for the y-axis. Default is "CDF".}

\item{colors}{Vector of colors for the lines. Default is \code{rainbow}.}

\item{shade_colors}{Vector of colors for shading under curves. Default is semi-transparent version of \code{colors}.}

\item{lwd}{Line width. Default is 3.}

\item{lty}{Line type. Default is 2 (dashed).}

\item{grid}{Logical, whether to draw a grid. Default is TRUE.}

\item{grid_lty}{Line type for grid. Default is 3.}

\item{grid_col}{Grid color. Default is "gray80".}

\item{grid_lwd}{Grid line width. Default is 1.}
}
\value{
A CDF plot is displayed. The function invisibly returns NULL.
}
\description{
#' Plots the CDF of a probability distribution.
Supports multiple sets of parameters with shaded areas under the curves.
}
\examples{
# Example 1: Generalized Exponential Distribution
ge_cdf <- function(x, alpha, lambda) {
  (1 - exp(-lambda * x))^alpha
}
param_values <- list(
  list(alpha = 1, lambda = 1),
  list(alpha = 2, lambda = 1),
  list(alpha = 3, lambda = 0.5),
  list(alpha = 4, lambda = 1.5),
  list(alpha = 5, lambda = 2.5)
)
plot_cdf(cdf = ge_cdf, param_list = param_values, main = "CDF GE Distribution")

# Example 2: Exponentiated Weibull Distribution
cdf_expweibull <- function(x, a, b, c){
  (1 - exp(-(b*x)^c))^a
}
param_values <- list(
  list(a = 0.3, b = 1.2, c = 1.0),
  list(a = 1.3, b = 0.4, c = 2.3),
  list(a = 1.5, b = 0.9, c = 3.0),
  list(a = 2.0, b = 1.8, c = 2.8),
  list(a = 3.7, b = 2.0, c = 1.5)
)
colors <- c("green", "purple", "yellow", "orange", "darkblue")
plot_cdf(cdf = cdf_expweibull, param_list = param_values,
         main = "CDF of EW Distribution", colors = colors, xlim = c(0, 5))

}
