% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_undirected_graph}
\alias{create_undirected_graph}
\title{Create Undirected Graph}
\usage{
create_undirected_graph(graph_df, by = NULL, ...)
}
\arguments{
\item{graph_df}{A data frame representing a directed graph including columns:
\code{from}, \code{to}, and (optionally) \code{edge}, \code{FX}, \code{FY}, \code{TX}, \code{TY}.}

\item{by}{Link characteristics to preserve/not aggregate across, passed as a one-sided formula or character vector of column names. Typically this includes attributes like \emph{mode}, \emph{type}, or \emph{capacity} to ensure that only edges with the same characteristics are aggregated.}

\item{\dots}{Arguments passed to \code{\link[collapse]{collap}()} for aggregation across duplicated (diretional) edges. The defaults are \code{FUN = fmean} for numeric columns and \code{catFUN = fmode} for categorical columns. Select columns using \code{cols} or use argument \code{custom = list(fmean = cols1, fsum = cols2, fmode = cols3)} to map different columns to specific aggregation functions. You can weight the aggregation (using \code{w = ~ weight_col}).}
}
\value{
A data frame representing an undirected graph with:
  \itemize{
    \item \code{edge} - Edge identifier (first value from duplicates)
    \item \code{from} - Starting node ID (normalized to be < \code{to})
    \item \code{to} - Ending node ID (normalized to be > \code{from})
    \item \code{FX} - Starting node X-coordinate (first value from duplicates)
    \item \code{FY} - Starting node Y-coordinate (first value from duplicates)
    \item \code{TX} - Ending node X-coordinate (first value from duplicates)
    \item \code{TY} - Ending node Y-coordinate (first value from duplicates)
    \item Aggregated columns
  }
}
\description{
Convert a directed graph to an undirected graph by normalizing edges and aggregating duplicate connections.
}
\details{
This function converts a directed graph to an undirected graph by:
\itemize{
  \item Normalizing edge directions so that \code{from < to} for all edges
  \item Collapsing duplicate edges (same \code{from} and \code{to} nodes)
  \item For spatial/identifier columns (\code{edge}, \code{FX}, \code{FY}, \code{TX}, \code{TY}),
    taking the first value from duplicates
  \item For aggregation columns, \code{\link[collapse]{collap}()} will be applied.
}
}
\examples{
library(flownet)

# Convert segments to graph and make undirected
graph <- africa_segments |>
  linestrings_from_graph() |>
  linestrings_to_graph()
graph_undir <- create_undirected_graph(graph, FUN = "fsum")

# Fewer edges after removing directional duplicates
c(directed = nrow(graph), undirected = nrow(graph_undir))

}
