% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_constructor.R
\name{motifSimulationBuilder}
\alias{motifSimulationBuilder}
\title{Create motifSimulation Object}
\usage{
motifSimulationBuilder(
  N,
  len,
  mot_details,
  norder = 3,
  coeff_min = -15,
  coeff_max = 15,
  dist_knots = 10,
  min_dist_motifs = NULL,
  distribution = "beta",
  motif_seed = NULL
)
}
\arguments{
\item{N}{An integer specifying the number of background curves to be generated (mandatory).}

\item{len}{An integer specifying the length of the background curves (mandatory).}

\item{mot_details}{A list outlining the definitions of the motifs to be included. Each motif is characterized by its length, a set of coefficients that may be optionally specified, and the number of occurrences. These occurrences can be indicated either by specific positions within the curves or by a total count. In the latter case, the algorithm will randomly position the motifs throughout the curves (mandatory).}

\item{norder}{An integer specifying the order of the B-splines (default = 3).}

\item{coeff_min}{Additive coefficients to be incorporated into the generation of coefficients for the background curves (default = -15).}

\item{coeff_max}{Additive coefficients to be incorporated into the generation of coefficients for the background curves (default = 15).}

\item{dist_knots}{An integer specifying the distance between two consecutive knots (default = 10).}

\item{min_dist_motifs}{An integer specifying the minimum distance between two consecutive motifs embedded in the same curve (default = 'norder' * 'dist_knots').}

\item{distribution}{A character string specifying the distribution from which the coefficients of the background curves are generated. You can choose between a uniform distribution or a beta distribution. Alternatively, you can pass a vector representing the empirical distribution from which you wish to sample (default = "beta").}

\item{motif_seed}{Set the seed for motif b-spline coefficients generation (default = NULL, i.e., random)}
}
\value{
An object of class motifSimulation
}
\description{
It represents the constructor of the S4 class 'motifSimulation'..
}
\examples{
\donttest{
mot_len <- 100
motif_str <- rbind.data.frame(c(1, 1, 20),
                              c(2, 1, 2), 
                              c(1, 3, 1),
                              c(1, 2, 1),
                              c(1, 2, 15),
                              c(1, 4, 1),
                              c(2, 5, 1),
                              c(2, 7, 1),
                              c(2,17,1))

names(motif_str) <- c("motif_id", "curve","start_break_pos")

mot1 <- list("len" = mot_len, #length
             "coeffs" = NULL, # weights for the motif
             "occurrences" = motif_str \%>\% filter(motif_id == 1))

mot2 <- list("len" = mot_len,
             "coeffs" = NULL,
             "occurrences" = motif_str \%>\% filter(motif_id == 2))

mot_details <- list(mot1,mot2)

# MATRIX ERROR 
noise_str <- list(rbind(rep(2, 100)),
                  rbind(rep(0.0, 100)))

builder <- funMoDisco::motifSimulationBuilder(N = 20,len = 300, mot_details,
                                        distribution = 'beta')
}
}
