% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumsumCPA_test.R
\name{cumsumCPA_test}
\alias{cumsumCPA_test}
\title{Change Point Detection in Time Series via a Linear Regression with Temporally Correlated
Errors}
\usage{
cumsumCPA_test(
  y,
  a.order,
  crit.type = c("asymptotic", "bootstrap"),
  bootstrap.method = c("nonparametric", "parametric"),
  num.bootstrap = 1000
)
}
\arguments{
\item{y}{a numeric time series vector. Missing values are not allowed.}

\item{a.order}{order of the autoregressive model which must be a non-negative integer number.}

\item{crit.type}{a string parameter allowing to choose "asymptotic" or "bootstrap" options.}

\item{bootstrap.method}{a string parameter allowing to choose "nonparametric" or
"parametric" method of bootstrapping. "nonparametric" -- resampling of the estimated
residuals (with replacement); "parametric" -- sampling innovations from a normal distribution.}

\item{num.bootstrap}{number of bootstrap replications if \code{crit.type = "bootstrap"}.
The default number is 1000.}
}
\value{
A list with the following components:
\item{index}{time point where the change has occurred.}
\item{stat}{test statistic.}
\item{p.value}{\code{p-value} of the change point test.}
}
\description{
The function tests for a change point in parameters of a linear regression model with errors
exhibiting a general weakly dependent structure. The approach extends earlier methods based
on cumulative sums derived under the assumption of independent errors. The approach applies
smoothing when the time series is dominated by high frequencies. To detect multiple changes,
it is recommended to employ a binary or wild segmentation \insertCite{Gombay_2010}{funtimes}.
}
\examples{
\dontrun{
#Example 1:

#Simulate some time series:
series_1 = rnorm(157, 2, 1)
series_2 = rnorm(43, 7, 10)
main_val = c(series_1, series_2)

#Now perform a change point detection:
cumsumCPA_test(series_1, 1) # no change
cumsumCPA_test(main_val, 1) # one change, asymptotic critical region
cumsumCPA_test(main_val, 1, "bootstrap", "parametric") # one change, parametric bootstrap
cumsumCPA_test(main_val, 1, "bootstrap", "nonparametric") # one change, nonparametric 
#bootstrap

#Example 2:

#Consider time series with ratio of real GDP per family to the median income. This is a
#skewness and income inequality measure for the US families from 1947 till 2012. 
e.data = (Ecdat::incomeInequality['mean.median'])
incomeInequality.ts = ts(e.data, start = 1947, end = 2012, frequency = 1)

#Now perform a change point detection:
cumsumCPA_test(incomeInequality.ts, 0)
cumsumCPA_test(incomeInequality.ts, 0, "bootstrap", "parametric")
cumsumCPA_test(incomeInequality.ts, 0, "bootstrap", "nonparametric")
incomeInequality.ts[13] # median income
Ecdat::incomeInequality$Year[13] + 1 # year of change point

#The first change point occurs at the 13th time point, that is 1960, where the ratio of real 
#GDP per family to the median income is 1.940126. This ratio shows that in 1960 the national
#wealth was not distributed equally between all the population and that most people earn 
#almost twice less than the equal share of the all produced goods and services by the nation.

#Note: To look for the other possible change points, run the same function for the 
#segment of time series after value 13.
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mcusum_test}} for change point test for regression
}
\author{
Palina Niamkova, Dorcas Ofori-Boateng, Yulia R. Gel
}
\keyword{changepoint}
\keyword{ts}
