import_from <- function(name, mode = "function", default = NULL, package) {
  ns <- getNamespace(package)
  if (exists(name, mode = mode, envir = ns, inherits = FALSE)) {
    get(name, mode = mode, envir = ns, inherits = FALSE)
  } else if (!is.null(default)) {
    default
  } else {
    stop(sprintf("No such '%s' function: %s()", package, name))
  }
}

## The 'futurize' package don't really need to have a hard dependency on
## the 'future' package. However, we make 'futurize' attach 'future' for
## conveniency so that `plan()` is available.
#' @importFrom future plan
import_future <- function(name, default = NULL) {
  import_from(name, default = default, package = "future")
}
