% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeBatch.R
\name{describeBatch}
\alias{describeBatch}
\title{describeBatch}
\usage{
describeBatch(dataLoader, zeroStart = FALSE)
}
\arguments{
\item{dataLoader}{Instantiated instance of a DataLoader created using torch::dataloader().}

\item{zeroStart}{TRUE or FALSE. If class indices start at 0, set this to TRUE. If they start at 1,
set this to FALSE. Default is FALSE.}
}
\value{
List object summarizing a mini-batch of image chips and masks.
}
\description{
Generate summary information for a batch of image chips and masks.
}
\details{
The goal of this function is to provide a check of a mini-batch of image chips and associated
masks generated by a DataLoader instance using defineSegDataSet(). Summary information includes the mini-batch size
(batchSize); image chip data type (imageDataType); mask data type (maskDataType); the shape of the mini-batch of images
or predictor variables as mini-batch size, number of channels, width pixel count, and height pixel count (imageShape); the mask shape
(maskShape); image band means (bndMns); image band standard deviations (bndSDs);
count of pixels in each class in the mini-batch (maskCnts); and minimum (minIndex) and maximum (maxIndex) class indices present in the mini-batch.
}
\examples{
\dontrun{
trainStats <- describeBatch(trainDL,
tzeroStart=TRUE,
tusedDS=FALSE)
}
}
