% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrow_key.R
\name{draw_key_arrow}
\alias{draw_key_arrow}
\title{Legend key glyph for arrows}
\usage{
draw_key_arrow(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
An \verb{<arrow_path>} grob
}
\description{
Like any \link[ggplot2:draw_key]{legend key glyphs}, this key can be used to
display arrows in a legend.
}
\examples{
ggplot(mpg, aes(displ, colour = factor(cyl))) +
  geom_density(key_glyph = draw_key_arrow)
}
