% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-documentation-with-examples.R
\name{gf_linerange_interactive}
\alias{gf_linerange_interactive}
\title{Interactive linerange plots}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain. Most users can safely ignore this argument.}

\item{gformula}{A formula with shape \code{y ~ x}. Faceting can be achieved by
including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer.}

\item{tooltip}{A formula specifying a variable for tooltips, or a character vector.}

\item{data_id}{A formula or character vector specifying data identifiers
for interactive selection.}

\item{...}{Additional arguments passed to the underlying geom.}

\item{alpha, color, size, shape, fill, group, stroke}{Aesthetics passed to the geom.}

\item{xlab, ylab, title, subtitle, caption}{Labels for the plot.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{show.help}{Logical. If \code{TRUE}, display some minimal help.}

\item{inherit}{Logical. If \code{TRUE}, inherit aesthetics from previous layers.}

\item{environment}{An environment in which to evaluate the formula.}
}
\value{
A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.
}
\description{
Creates an interactive plot using ggiraph. This function extends
\code{\link[=gf_linerange]{gf_linerange()}} with interactive features like tooltips and clickable elements.
}
\section{Additional interactive features}{

\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}
}

\examples{
diamonds |>
  dplyr::filter(carat < 1.1, carat > 0.9) |>
  dplyr::group_by(color, cut) |>
  dplyr::summarise(
    median_price = median(price) |> round(),
    lower = quantile(price, 0.25) |> round(),
    upper = quantile(price, 0.75) |> round(),
    iqr = upper - lower
  ) |>
  gf_linerange_interactive(
    cut ~ lower + upper | color,
    color = ~ cut,
    tooltip = ~ paste0(
      "75th percentile: ", upper,
      "\nmedian: ", median_price,
      "\n25th percentile: ", lower
      )
  ) |>
  gf_girafe()

}
\seealso{
\code{\link[=gf_linerange]{gf_linerange()}}, \code{\link[=gf_girafe]{gf_girafe()}}
}
