% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{as_group}
\alias{as_group}
\title{Collect layers into a group that can be treated as a single layer}
\usage{
as_group(..., id = NULL, include = is.null(id))
}
\arguments{
\item{...}{A range of layers to combine}

\item{id}{A string identifying this layer for later use}

\item{include}{Should the layer itself be included in the graphic}
}
\value{
A list of \code{Layer} objects or a \link[grid:grid.grob]{gTree} depending on the
input
}
\description{
While you often want to apply filters to layers one by one, there are times
when one filter should be applied to a collection of layers as if they were
one. This can be achieved by first combining all the layers into a group with
\code{as_group()} and applying the filter to the resulting group. This can only be
done to ggplot2 layers and grobs as the other supported objects are not part
of a graphic stack.
}
\examples{
library(ggplot2)

# With no grouping the filters on layers are applied one by one
ggplot(mtcars, aes(mpg, disp)) +
  with_shadow(geom_smooth(alpha = 1), sigma = 4) +
  with_shadow(geom_point(), sigma = 4)

# Grouping the layers allows you to apply a filter on the combined result
ggplot(mtcars, aes(mpg, disp)) +
  as_group(
    geom_smooth(alpha = 1),
    geom_point(),
    id = 'group_1'
  ) +
  with_shadow('group_1', sigma = 4)

}
\seealso{
Other layer references: 
\code{\link{as_colourspace}()},
\code{\link{as_reference}()}
}
\concept{layer references}
