% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.R
\name{with_custom}
\alias{with_custom}
\title{Apply a custom filter}
\usage{
with_custom(x, filter, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{filter}{A function taking a \code{nativeRaster} object as the first argument
along with whatever you pass in to \code{...}}

\item{...}{Additional arguments to \code{filter}}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This function allows you to apply a custom filtering function to a layer. The
function must take a \code{nativeRaster} object as the first argument along with
any other arguments passed to \code{...}. Be aware that the raster spans the full
device size and not just the viewport currently rendered to. This is because
graphics may extend outside of the viewport depending on the clipping
settings. You can use \code{\link[=get_viewport_area]{get_viewport_area()}} along with all the other raster
helpers provided by ggfx to facilitate working with the input raster. See the
example below for some inspiration.
}
\examples{
library(ggplot2)
flip_raster <- function(raster, horizontal = TRUE) {
  # Get the viewport area of the raster
  vp <- get_viewport_area(raster)

  # Get the columns and rows of the raster - reverse order depending on
  # the value of horizontal
  dims <- dim(vp)
  rows <- seq_len(dims[1])
  cols <- seq_len(dims[2])
  if (horizontal) {
    cols <- rev(cols)
  } else {
    rows <- rev(rows)
  }

  # change the order of columns or rows in the viewport raster
  vp <- index_raster(vp, cols, rows)

  # Assign the modified viewport back
  set_viewport_area(raster, vp)
}

ggplot() +
  with_custom(
    geom_text(aes(0.5, 0.75, label = 'Flippediflop!'), size = 10),
    filter = flip_raster,
    horizontal = TRUE
  )

ggplot() +
  with_custom(
    geom_text(aes(0.5, 0.75, label = 'Flippediflop!'), size = 10),
    filter = flip_raster,
    horizontal = FALSE
  )

}
