% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_mock_data.R
\name{generate_mock_data}
\alias{generate_mock_data}
\title{Generate mock data for gglyph::geom_glyph()}
\usage{
generate_mock_data(
  n_nodes = 5,
  n_edges = 7,
  n_groups = 1,
  statistical = FALSE,
  p_threshold = 0.05
)
}
\arguments{
\item{n_nodes}{Number of nodes in the graph. Default is 5.}

\item{n_edges}{Number of edges to generate. Default is 7.}

\item{n_groups}{Number of groups (for faceting). Default is 1 (ungrouped).}

\item{statistical}{If TRUE, generates mock p-values for edges. Default is FALSE.}

\item{p_threshold}{The significance threshold for filtering edges. Default is 0.05.}
}
\value{
A data frame with mock data for nodes and edges.
}
\description{
Generates custom mock data to be passed to gglyph::geom_glyph().
}
\examples{
# For non-grouped data
mock_data <- generate_mock_data(
  n_nodes = 5,
  n_edges = 7,
  n_groups = 1,
  statistical = FALSE,
  p_threshold = 0.05
)

# For grouped data
mock_data <- generate_mock_data(
  n_nodes = 5,
  n_edges = 7,
  n_groups = 3,
  statistical = TRUE,
  p_threshold = 0.05
)
}
