#' Gene Expression Analysis Dataset
#'
#' A dataset containing gene expression analysis results.
#' It has seven columns capturing various statistics related to gene expression.
#'
#' @format A data frame with the following columns:
#' \describe{
#'   \item{genes}{Character. Gene name or identifier.}
#'   \item{baseMean}{Numeric. The base mean value for the gene across samples.}
#'   \item{log2FoldChange}{Numeric. The log2 fold change of gene expression. Positive values indicate upregulation and negative values indicate downregulation.}
#'   \item{lfcSE}{Numeric. Standard error of the log2 fold change.}
#'   \item{stat}{Numeric. The Wald statistic for the gene's expression change.}
#'   \item{pvalue}{Numeric. Raw p-value for the test of the gene's expression change.}
#'   \item{padj}{Numeric. Adjusted p-value for multiple testing corrections.}
#' }
"all_genes"


#' Attention Genes Dataset
#'
#' A dataset containing specific genes of interest referred to as "attention genes".
#'
#' @format A data frame with 10 rows and 7 variables:
#' \describe{
#'   \item{genes}{Character. Gene name or identifier.}
#'   \item{baseMean}{Numeric vector: Base mean expression level of genes}
#'   \item{log2FoldChange}{Numeric vector: Log2 Fold Change of gene expression}
#'   \item{lfcSE}{Numeric vector: Standard error for log2 fold change}
#'   \item{stat}{Numeric vector: Wald statistic for the gene's expression change}
#'   \item{pvalue}{Numeric vector: Raw p-value from Wald test}
#'   \item{padj}{Numeric vector: Adjusted p-value for multiple testing using the Benjamini-Hochberg procedure}
#' }
"attention_genes"
