% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{GraphqlClient}
\alias{GraphqlClient}
\title{GraphqlClient}
\value{
a `GraphqlClient` class (R6 class)
}
\description{
R6 class for constructing GraphQL queries
}
\examples{
x <- GraphqlClient$new()
x

\dontrun{
# make a client
token <- Sys.getenv("GITHUB_TOKEN")
cli <- GraphqlClient$new(
  url = "https://api.github.com/graphql",
  headers = list(Authorization = paste0("Bearer ", token))
)

# if the GraphQL server has a schema, you can load it
cli$load_schema()

# dump schema to local file
f <- tempfile(fileext = ".json")
cli$dump_schema(file = f)
readLines(f)
jsonlite::fromJSON(readLines(f))

# after dumping to file, you can later read schema from file for faster loading
rm(cli)
cli <- GraphqlClient$new(
  url = "https://api.github.com/graphql",
  headers = list(Authorization = paste0("Bearer ", token))
)
cli$load_schema(schema_file = f)

# variables
cli$url
cli$schema
cli$schema$data
cli$schema$data$`__schema`
cli$schema$data$`__schema`$queryType
cli$schema$data$`__schema`$mutationType
cli$schema$data$`__schema`$subscriptionType
head(cli$schema$data$`__schema`$types)
cli$schema$data$`__schema`$directives


# methods
## ping - hopefully you get TRUE
cli$ping()

## dump schema
cli$schema2json()


## define query
### creat a query class first
qry <- Query$new()
## another
qry$query('repos', '{
  viewer {
    repositories(last: 10, isFork: false, privacy: PUBLIC) {
      edges {
        node {
          isPrivate
          id
          name
        }
      }
    }
  }
}')
qry
qry$queries
qry$queries$repos
### execute the query
cli$exec(qry$queries$repos)


# query with a fragment
### define query without fragment, but referring to it
qry <- Query$new()
qry$query('queryfrag', '{
  ropensci: repositoryOwner(login:"ropensci") {
    repositories(first: 3) {
      edges {
        node {
          ...Watchers
        }
      }
    }
  }
  ropenscilabs: repositoryOwner(login:"ropenscilabs") {
    repositories(first: 3) {
      edges {
        node {
          ...Watchers
        }
      }
    }
  }
}')

### define a fragment
frag <- Fragment$new()
frag$fragment('Watchers', '
  fragment on Repository {
    watchers(first: 3) {
      edges {
        node {
          name
       }
    }
  }
}')
frag$fragments
frag$fragments$Watchers

### add the fragment to the query 'queryfrag'
qry$add_fragment('queryfrag', frag$fragments$Watchers)
qry
qry$queries$queryfrag

### execute query: we'll hook together the query and your fragment internally
cli$exec(qry$queries$queryfrag)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{url}}{(character) list of fragments}

\item{\code{headers}}{list of named headers}

\item{\code{schema}}{holds schema}

\item{\code{result}}{holds result from http request}

\item{\code{fragments}}{(list) list of fragments}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GraphqlClient-new}{\code{GraphqlClient$new()}}
\item \href{#method-GraphqlClient-print}{\code{GraphqlClient$print()}}
\item \href{#method-GraphqlClient-ping}{\code{GraphqlClient$ping()}}
\item \href{#method-GraphqlClient-load_schema}{\code{GraphqlClient$load_schema()}}
\item \href{#method-GraphqlClient-dump_schema}{\code{GraphqlClient$dump_schema()}}
\item \href{#method-GraphqlClient-schema2json}{\code{GraphqlClient$schema2json()}}
\item \href{#method-GraphqlClient-fragment}{\code{GraphqlClient$fragment()}}
\item \href{#method-GraphqlClient-exec}{\code{GraphqlClient$exec()}}
\item \href{#method-GraphqlClient-prep_query}{\code{GraphqlClient$prep_query()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-new}{}}}
\subsection{Method \code{new()}}{
Create a new `GraphqlClient` object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$new(url, headers)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{(character) URL for the GraphQL schema}

\item{\code{headers}}{Any acceptable headers, a named list. See examples}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `GraphqlClient` object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-print"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-print}{}}}
\subsection{Method \code{print()}}{
print method for the `GraphqlClient` class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-ping"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-ping}{}}}
\subsection{Method \code{ping()}}{
ping the GraphQL server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$ping(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{curl options passed on to [crul::verb-HEAD]}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`TRUE` if successful response, `FALSE` otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-load_schema"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-load_schema}{}}}
\subsection{Method \code{load_schema()}}{
load schema, from URL or local file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$load_schema(schema_url = NULL, schema_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schema_url}}{(character) url for a schema file}

\item{\code{schema_file}}{(character) path to a schema file}

\item{\code{...}}{curl options passed on to [crul::verb-GET]}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing, loads schema into `$schema` slot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-dump_schema"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-dump_schema}{}}}
\subsection{Method \code{dump_schema()}}{
dump schema to a local file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$dump_schema(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) path to a file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing, writes schema to `file`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-schema2json"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-schema2json}{}}}
\subsection{Method \code{schema2json()}}{
convert schema to JSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$schema2json(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{options passed on to [jsonlite::toJSON()]}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
json
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-fragment"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-fragment}{}}}
\subsection{Method \code{fragment()}}{
load schema, from URL or local file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$fragment(name, x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(character) fragment name}

\item{\code{x}}{(character) the fragment}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; sets fragments internally
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-exec"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-exec}{}}}
\subsection{Method \code{exec()}}{
execute the query
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$exec(
  query,
  variables,
  encoding = "UTF-8",
  response_headers = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{(character) a query, of class `query` or `fragment`}

\item{\code{variables}}{(list) named list with query variables values}

\item{\code{encoding}}{(character) encoding to use to parse the response. passed
on to [crul::HttpResponse] `$parse()` method. default: "UTF-8"}

\item{\code{response_headers}}{If `TRUE`, include the response headers as an
attribute of the return object.}

\item{\code{...}}{curl options passed on to [crul::verb-POST]}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character string of response, if successful
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphqlClient-prep_query"></a>}}
\if{latex}{\out{\hypertarget{method-GraphqlClient-prep_query}{}}}
\subsection{Method \code{prep_query()}}{
not used right now
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphqlClient$prep_query(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{(character) a query, of class `query` or `fragment`}
}
\if{html}{\out{</div>}}
}
}
}
