% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradLasso.R
\name{gradLasso}
\alias{gradLasso}
\title{Gradient Descent LASSO with Stability Selection}
\usage{
gradLasso(
  formula,
  data = NULL,
  family = grad_gaussian(),
  lambda = NULL,
  lambda_cv = TRUE,
  standardize = TRUE,
  cv_subsample = NULL,
  parallel = FALSE,
  n_cores = NULL,
  boot = TRUE,
  n_boot = 50,
  boot_ci = c(0.025, 0.975),
  batch_size = NULL,
  warm_start = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{formula}{Formula object. Supports pipes for ZINB (e.g., y ~ x1 + x2 | z1).}

\item{data}{Data frame.}

\item{family}{Family object.}

\item{lambda}{Optional fixed lambda.}

\item{lambda_cv}{Configuration for CV.}

\item{standardize}{Logical. Standardize predictors?}

\item{cv_subsample}{Integer. Speedup for CV.}

\item{parallel}{Logical. Enable parallel processing?}

\item{n_cores}{Integer. Number of cores.}

\item{boot}{Logical. Run stability selection?}

\item{n_boot}{Number of bootstraps.}

\item{boot_ci}{Vector of two probabilities for CIs.}

\item{batch_size}{Integer. Mini-batch SGD.}

\item{warm_start}{Logical. Warm start bootstraps.}

\item{verbose}{Logical. Print progress to console?}
}
\value{
An object of class \code{gradLasso}. This is a list containing:
\item{coefficients}{A named vector of the final estimated regression coefficients.}
\item{fitted.values}{A vector of the fitted values (response scale).}
\item{residuals}{A vector of the residuals (observed - fitted).}
\item{lambda}{The penalty term (lambda) used for the final model.}
\item{boot_matrix}{A matrix of bootstrap coefficient estimates (rows=iterations, cols=features), or NULL if \code{boot=FALSE}.}
\item{cv_results}{A list containing cross-validation metrics (if \code{lambda_cv=TRUE}), including \code{lambda.min}.}
\item{family}{The family object used for the fit.}
\item{deviance}{The final model deviance.}
\item{nobs}{The number of observations used.}
}
\description{
Gradient Descent LASSO with Stability Selection
}
