% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{Wilcoxon}
\alias{Wilcoxon}
\title{Perform Wilcoxon tests for differential expression}
\usage{
Wilcoxon(
  data,
  name.prefix = get.mode.slot(data, mode.slot)$mode,
  contrasts,
  mode.slot = DefaultSlot(data),
  genes = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{the grandR object}

\item{name.prefix}{the prefix for the new analysis name; a dot and the column names of the contrast matrix are appended; can be NULL (then only the contrast matrix names are used)}

\item{contrasts}{contrast matrix that defines all pairwise comparisons, generated using \link{GetContrasts}}

\item{mode.slot}{compute mode.slot to use (should be normalized values)}

\item{genes}{restrict analysis to these genes; NULL means all genes}

\item{verbose}{print status messages?}
}
\value{
a new grandR object including a new analysis table. The columns of the new analysis table are
 \item{"P"}{the Wilcoxon test P value}
 \item{"Q"}{same as P but Benjamini-Hochberg multiple testing corrected}
 \item{"LFC"}{the log2 fold change (only with the logFC parameter set to TRUE)}
}
\description{
Apply the wilcoxon test for comparisons defined in a contrast matrix, requires the presto package for fast computation.
}
\seealso{
\link{LFC},\link{GetContrasts}
}
\concept{diffexp}
