% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_causality}
\alias{example_causality}
\title{Example Time Series Data with Known Causal Relationship}
\format{
A data frame with 200 rows and 3 variables:
\describe{
\item{time}{Integer. Time index from 1 to 200.}
\item{cause_x}{Numeric. The "cause" time series, a random walk.}
\item{effect_y}{Numeric. The "effect" time series, which depends on lagged values of cause_x.}
}
}
\source{
Simulated data generated with seed 42.
}
\usage{
example_causality
}
\description{
A dataset containing two time series where \code{cause_x} Granger-causes \code{effect_y}.
This data is useful for demonstrating and testing the Granger causality test.
}
\details{
The data was generated with the following process:
\itemize{
\item \code{cause_x} is a random walk: \eqn{X_t = X_{t-1} + \epsilon_t}
\item \code{effect_y} depends on lagged \code{cause_x}: \eqn{Y_t = 0.7 \cdot X_{t-1} + \nu_t}
}
where \eqn{\epsilon_t \sim N(0, 1)} and \eqn{\nu_t \sim N(0, 0.5^2)}.

When tested, \code{cause_x} should Granger-cause \code{effect_y}, but not vice versa.
}
\examples{
data(example_causality)

# Test for Granger causality
result <- granger_causality_test(
  example_causality,
  cause_x,
  effect_y
)
print(result)

}
\keyword{datasets}
