% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_gsdc}
\alias{get_gsdc}
\title{Download Greenspace Seasonality Data Cube}
\usage{
get_gsdc(
  bbox = NULL,
  place = NULL,
  location = NULL,
  UID = NULL,
  year = NULL,
  time = NULL,
  mask = TRUE,
  quiet = TRUE
)
}
\arguments{
\item{bbox}{\code{sf}, \code{sfc}, or a numeric vector (xmin, ymin, xmax, ymax)
defining the area of interest. Optional if \code{place}, \code{location}, or \code{UID} is provided.}

\item{place}{character or vector. (optional) A single line address,
e.g. ("1600 Pennsylvania Ave NW, Washington") or a vector of addresses
(c("Madrid", "Barcelona")). This can be ignored if \code{location} is specified.}

\item{location}{vector or sf point. A point of interest.
Ignored if \code{UID} is specified.}

\item{UID}{numeric. Urban area ID. To check the ID of an available urban area,
use \code{\link[=check_available_urban]{check_available_urban()}}}

\item{year}{numeric. (required) The year of interest.}

\item{time}{Character vector of length 2 or character. (optional) Start and end dates in
\code{"MM-DD"} format (e.g., \code{c("03-20", "10-15")} or \code{"07-10"}). Used to subset the 10-day
interval data cube by time.}

\item{mask}{logical (optional). Default is \code{TRUE}. If \code{TRUE}, masks the
raster data using the given \code{bbox} or \code{place} if it is specified.}

\item{quiet}{logical. Whether show progress bars for some process.}
}
\value{
A \code{SpatRaster} object containing the greenspace seasonality data.
}
\description{
download Greenspace Seasonality Data Cube for an urban area.
Retrieves high-resolution greenspace seasonality data from the Sentinel-2-based
global dataset developed by Wu et al. (2024). Users can define a city of interest
using a bounding box, place name, coordinates, or unique city ID (UID).
}
\details{
The Greenspace Data Cube is organized into 36 bands per year,
each representing a 10-day interval.
}
\note{
Use \code{\link[=check_available_urban]{check_available_urban()}} and \code{\link[=check_urban_boundary]{check_urban_boundary()}} to see supported
cities and their boundaries.
}
\examples{
result <- get_gsdc(UID = 0,
                   # year = 2022
                  )

}
\references{
Wu, S., Song, Y., An, J. et al. High-resolution greenspace dynamic
data cube from Sentinel-2 satellites over 1028 global major cities.
Sci Data 11, 909 (2024). https://doi.org/10.1038/s41597-024-03746-7
}
