% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pct_bar.R
\name{gt_plt_bar_stack}
\alias{gt_plt_bar_stack}
\title{Add a percent stacked barchart in place of existing data.}
\usage{
gt_plt_bar_stack(
  gt_object,
  column = NULL,
  palette = c("#ff4343", "#bfbfbf", "#0a1c2b"),
  labels = c("Group 1", "Group 2", "Group 3"),
  position = "fill",
  width = 70,
  fmt_fn = scales::label_number(scale_cut = cut_short_scale(), trim = TRUE),
  font = "mono"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the percent stacked barchart should replace existing data. Note that the data \emph{must} be represented as a list of numeric values ahead of time.}

\item{palette}{A color palette of length 2 or 3, represented either by hex colors (\code{"#ff4343"}) or named colors (\code{"red"}).}

\item{labels}{A vector of strings of length 2 or 3, representing the labels for the bar chart, will be colored according to the palette as well.}

\item{position}{An string indicator passed to \code{ggplot2} indicating if the bar should be a percent of total \code{"fill"} or stacked as the raw values \code{"stack"}.}

\item{width}{An integer representing the width of the bar chart in pixels.}

\item{fmt_fn}{A specific function from \verb{scales::label_???} family. Defaults to \code{scales::label_number()}}

\item{font}{A string representing the font family of the numbers of the bar labels. Defaults to \code{mono}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_bar_stack} function takes an existing \code{gt_tbl} object and
converts the existing values into a percent stacked barchart. The bar chart
will represent either 2 or 3 user-specified values per row, and requires
a list column ahead of time. The palette and labels need to be equal length.
The values must either add up to 100 ie as percentage points if using
\code{position = 'fill'}, or can be raw values with \code{position = 'stack'}. Note that
the labels can be controlled via the \code{fmt_fn} argument and the
\verb{scales::label_???()} family of function.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
library(dplyr)

ex_df <- dplyr::tibble(
  x = c("Example 1","Example 1",
        "Example 1","Example 2","Example 2","Example 2",
        "Example 3","Example 3","Example 3","Example 4","Example 4",
        "Example 4"),
  measure = c("Measure 1","Measure 2",
              "Measure 3","Measure 1","Measure 2","Measure 3",
              "Measure 1","Measure 2","Measure 3","Measure 1","Measure 2",
              "Measure 3"),
  data = c(30, 20, 50, 30, 30, 40, 30, 40, 30, 30, 50, 20)
)


tab_df <- ex_df \%>\%
  group_by(x) \%>\%
  summarise(list_data = list(data))

tab_df

ex_tab <- tab_df \%>\%
  gt() \%>\%
  gt_plt_bar_stack(column = list_data)
}\if{html}{\out{</div>}}

\if{html}{\figure{plt-bar-stack.png}{options: width=500}}
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
