% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm-marginals.R
\name{dissimilarity.matrix}
\alias{dissimilarity.matrix}
\title{Dissimilarity of a co-occurrence matrix}
\usage{
dissimilarity.matrix(glcm)
}
\arguments{
\item{glcm}{gray-level co-occurrence matrix}
}
\value{
int or double (the weighted sum of differences)
}
\description{
Dissimilarity is the weighted sum of all of the absolute differences in the gray-levels assigned
to neighboring nodes across the network or graph. For example, a diagonal matrix would represent
only identical neighbors and no dissimilarity.
}
\examples{
# Calculate dissimilarity of a 2x2 uniform matrix
dissimilarity.matrix(matrix(1,2,2))

# Calculate dissimilarity of a diagonal matrix
dissimilarity.matrix(diag(1,5,5))

# Calculate dissimilarity of a sequential matrix
dissimilarity.matrix(matrix(1:16,4,4))

}
