% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tidiers.R
\name{custom_tidiers}
\alias{custom_tidiers}
\alias{tidy_standardize}
\alias{tidy_bootstrap}
\alias{tidy_robust}
\alias{pool_and_tidy_mice}
\alias{tidy_gam}
\alias{tidy_wald_test}
\title{Custom tidiers}
\usage{
tidy_standardize(
  x,
  exponentiate = FALSE,
  conf.level = 0.95,
  conf.int = TRUE,
  ...,
  quiet = FALSE
)

tidy_bootstrap(
  x,
  exponentiate = FALSE,
  conf.level = 0.95,
  conf.int = TRUE,
  ...,
  quiet = FALSE
)

tidy_robust(
  x,
  exponentiate = FALSE,
  conf.level = 0.95,
  conf.int = TRUE,
  vcov = NULL,
  vcov_args = NULL,
  ...,
  quiet = FALSE
)

pool_and_tidy_mice(x, pool.args = NULL, ..., quiet = FALSE)

tidy_gam(x, conf.int = FALSE, exponentiate = FALSE, conf.level = 0.95, ...)

tidy_wald_test(x, tidy_fun = NULL, vcov = stats::vcov(x), ...)
}
\arguments{
\item{x}{(\code{model})\cr
Regression model object}

\item{exponentiate}{(scalar \code{logical})\cr
Logical indicating whether to exponentiate the coefficient estimates.
Default is \code{FALSE}.}

\item{conf.level}{(scalar \code{real})\cr
Confidence level for confidence interval/credible interval. Defaults to \code{0.95}.}

\item{conf.int}{(scalar \code{logical})\cr
Logical indicating whether or not to include a confidence
interval in the output. Default is \code{TRUE}.}

\item{...}{Arguments passed to method;
\itemize{
\item \code{pool_and_tidy_mice()}: \code{mice::tidy(x, ...)}
\item \code{tidy_standardize()}: \code{parameters::standardize_parameters(x, ...)}
\item \code{tidy_bootstrap()}: \code{parameters::bootstrap_parameters(x, ...)}
\item \code{tidy_robust()}: \code{parameters::model_parameters(x, ...)}
}}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{vcov, vcov_args}{\itemize{
\item \code{tidy_robust()}: Arguments passed to \code{parameters::model_parameters()}.
At least one of these arguments \strong{must} be specified.
\item \code{tidy_wald_test()}: \code{vcov} is the covariance matrix of the model with default \code{stats::vcov()}.
}}

\item{pool.args}{(named \code{list})\cr
Named list of arguments passed to \code{mice::pool()} in
\code{pool_and_tidy_mice()}. Default is \code{NULL}}

\item{tidy_fun}{(\code{function})\cr
Tidier function for the model. Default is to use \code{broom::tidy()}.
If an error occurs, the tidying of the model is attempted with
\code{parameters::model_parameters()}, if installed.}
}
\description{
Collection of tidiers that can be utilized in gtsummary. See details below.
}
\section{Regression Model Tidiers}{
These tidiers are passed to \code{tbl_regression()} and \code{tbl_uvregression()} to
obtain modified results.
\itemize{
\item \code{tidy_standardize()} tidier to report standardized coefficients. The
\href{https://easystats.github.io/parameters/reference/standardize_parameters.html}{parameters}
package includes a wonderful function to estimate standardized coefficients.
The tidier uses the output from \code{parameters::standardize_parameters()}, and
merely takes the result and puts it in \code{broom::tidy()} format.
\item \code{tidy_bootstrap()} tidier to report bootstrapped coefficients. The
\href{https://easystats.github.io/parameters/reference/model_parameters.default.html}{parameters}
package includes a wonderful function to estimate bootstrapped coefficients.
The tidier uses the output from \code{parameters::bootstrap_parameters(test = "p")}, and
merely takes the result and puts it in \code{broom::tidy()} format.
\item \code{tidy_robust()} tidier to report robust standard errors, confidence intervals,
and p-values. The \href{https://easystats.github.io/parameters/reference/model_parameters.default.html}{parameters}
package includes a wonderful function to calculate robust standard errors, confidence intervals, and p-values
The tidier uses the output from \code{parameters::model_parameters()}, and
merely takes the result and puts it in \code{broom::tidy()} format. To use this
function with \code{tbl_regression()}, pass a function with the arguments for
\code{tidy_robust()} populated.
\item \code{pool_and_tidy_mice()} tidier to report models resulting from multiply imputed data
using the mice package. Pass the mice model object \emph{before} the model results
have been pooled. See example.
}
}

\section{Other Tidiers}{
\itemize{
\item \code{tidy_wald_test()} tidier to report Wald p-values, wrapping the
\code{aod::wald.test()} function.
Use this tidier with \code{add_global_p(anova_fun = tidy_wald_test)}
}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("effectsize", "mice", "parameters"))) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
mod <- lm(age ~ marker + grade, trial)

tbl_stnd <- tbl_regression(mod, tidy_fun = tidy_standardize)
tbl <- tbl_regression(mod)

tidy_standardize_ex1 <-
  tbl_merge(
    list(tbl_stnd, tbl),
    tab_spanner = c("**Standardized Model**", "**Original Model**")
  )

# Example 2 ----------------------------------
# use "posthoc" method for coef calculation
tbl_regression(mod, tidy_fun = \(x, ...) tidy_standardize(x, method = "posthoc", ...))

# Example 3 ----------------------------------
# Multiple Imputation using the mice package
set.seed(1123)
pool_and_tidy_mice_ex3 <-
  suppressWarnings(mice::mice(trial, m = 2)) |>
  with(lm(age ~ marker + grade)) |>
  tbl_regression()
\dontshow{\}) # examplesIf}
}
