% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_continuous.R
\name{plot_continuous}
\alias{plot_continuous}
\title{Plot a continuous variable by sub-groups}
\usage{
plot_continuous(
  data,
  outcome,
  by = NULL,
  drop_na_by = FALSE,
  convert_continuous = TRUE,
  ...,
  show_overall = TRUE,
  overall_label = "Overall",
  show_pvalues = TRUE,
  pvalues_labeller = scales::label_pvalue(add_p = TRUE),
  pvalues_size = 3.5,
  facet_labeller = ggplot2::label_wrap_gen(width = 50, multi_line = TRUE),
  flip = FALSE,
  minimal = FALSE,
  free_scale = FALSE,
  return_data = FALSE
)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{outcome}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of
continuous variables to be plotted.}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> List of variables to
group by (comparison is done separately for each variable).}

\item{drop_na_by}{Remove \code{NA} values in \code{by} variables?}

\item{convert_continuous}{Should continuous by variables (with 5 unique
values or more) be converted to quartiles (using \code{cut_quartiles()})?}

\item{...}{Additional arguments passed to \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}.}

\item{show_overall}{Display "Overall" column?}

\item{overall_label}{Label for the overall column.}

\item{show_pvalues}{Display p-values in the top-left corner? p-values are
computed with \code{\link[stats:kruskal.test]{stats::kruskal.test()}} for data frames, and with
\code{\link[survey:svyranktest]{survey::svyranktest()}} for survey objects.}

\item{pvalues_labeller}{Labeller function for p-values.}

\item{pvalues_size}{Text size for p-values.}

\item{facet_labeller}{Labeller function for strip labels.}

\item{flip}{Flip x and y axis?}

\item{minimal}{Should a minimal theme be applied? (no y-axis, no grid)}

\item{free_scale}{Allow y axis to vary between conditions?}

\item{return_data}{Return computed data instead of the plot?}
}
\description{
Plot one or several continuous variables by sub-groups. See \code{\link[=median_iqr]{median_iqr()}}
for more details on the way statistics are
computed. Return a box plot (see examples).
}
\examples{
iris |>
  plot_continuous(Petal.Length, by = Species)

iris |>
  plot_continuous(
    dplyr::starts_with("Petal"),
    by = Species,
    free_scale = TRUE,
    fill = "lightblue",
    outlier.color = "red"
  )

\donttest{

mtcars |>
  plot_continuous(
    mpg,
    by = c(cyl, gear),
    flip = TRUE,
    mapping = ggplot2::aes(fill = by)
  )

# works with continuous by variables
mtcars |>
  plot_continuous(
    mpg,
    by = c(disp, drat),
    flip = TRUE,
    minimal = TRUE
  )

# works with survey object
iris |>
  srvyr::as_survey() |>
  plot_continuous(
    Petal.Length,
    by = c(Species, Petal.Width),
    flip = TRUE
  )
}
}
\keyword{hplot}
