% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.group.R
\name{plot.group}
\alias{plot.group}
\title{Confidence interval graphs for group class objects}
\usage{
\method{plot}{group}(
  x,
  y = "group",
  order = "alpha",
  gcol = "blue",
  gband = FALSE,
  pcol = "red",
  overall = FALSE,
  ocol = "gray",
  oband = FALSE,
  tgt = NULL,
  tcol = "gray",
  tpline = NULL,
  tpcol = "gray",
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  lwd = 1,
  adj.alpha = 0.4,
  cex = 1,
  cex.axis = 1,
  cex.lab = 1,
  cex.main = 1,
  cex.text = 1,
  round.c = 2,
  name = FALSE,
  abbrv = 5,
  ...
)
}
\arguments{
\item{x}{group object.}

\item{y}{type of confidence interval object, specify either 'group', 'time', or 'roll'.}

\item{order}{specify confidence interval object order as 'alpha' or 'numeric' for alphabetical or numerical ordering in the 'group' graph.}

\item{gcol}{pick confidence interval line colors for groups in the 'group' graph. Default is 'blue'.}

\item{gband}{logical TRUE or FALSE that indicates whether group lines have confidence bands for trend over time results. Default is FALSE.}

\item{pcol}{select point color for 'group' only confidence intervals. Default is 'red'.}

\item{overall}{logical TRUE or FALSE that indicates whether to include the overall sample confidence intervals (i.e., not each group). Default is FALSE.}

\item{ocol}{indicate the optional overall line color. Default is 'gray' when overall=TRUE.}

\item{oband}{logical TRUE or FALSE that indicates whether to add an overall confidence band. Default is FALSE.}

\item{tgt}{specify 1 or more values on the x-axis of where to add a target line. Default is NULL.}

\item{tcol}{select a color for the target line. Default is 'gray'.}

\item{tpline}{add one or time point vertical line(s) using x-axis values when y='time' or y='roll'. Default is NULL.}

\item{tpcol}{specify a color for the time point line, tpline. Default is NULL.}

\item{xlim}{specify plot's x-axis limits with a 2 value vector.}

\item{ylim}{specify plot's y-axis limits with a 2 value vector.}

\item{main}{the main title of the plot.}

\item{lwd}{select the line width. Default is 1.}

\item{adj.alpha}{factor modifying the opacity alpha of the confidence interval bands, in the range of 0 to 1. Default is 0.4.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default of 1.}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex. Default is 1.}

\item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex. Default is 1.}

\item{cex.main}{The magnification to be used for main titles relative to the current setting of cex. Default is 1.}

\item{cex.text}{The magnification to be used for the text added into the plot relative to the current setting of 1.}

\item{round.c}{an integer indicating the number of decimal places. Default is 2.
to be used for rounding coefficient values.}

\item{name}{logical TRUE or FALSE that indicates whether group names
should be added to the 'time' or 'roll' plots. Default is FALSE.}

\item{abbrv}{the minimum length of the abbreviations. Default is 5.}

\item{...}{additional arguments.}
}
\value{
plot of group level confidence intervals, including estimates over time periods.
}
\description{
Confidence interval graphs for group class objects
}
\examples{
#Simple graph for confidence intervals using the t-distribution
gr1 <- group(x="program", y="los", z="month", dataf=hosprog, dist="t",
increment=3, rolling=6)
# Group level confidence intervals
plot(x=gr1, y="group", order="numeric", lwd=4, gcol= "blue", pcol="red",
overall=TRUE, oband=TRUE, ocol="gray", tcol="green", tgt=4.5,
cex=1, cex.axis=1, cex.lab=1, cex.text=2,
cex.main=1.25, name=TRUE, adj.alpha=.2)
#Trend plots over time in the 3 month increments (i.e., quarters)
plot(x=gr1, y="time", lwd=4, gcol=c("red", "blue"), gband=TRUE, overall=TRUE,
  oband=TRUE, ocol="gray", tcol="green", tgt=4, tpline=3,
  tpcol="yellow", name=TRUE, cex.axis=1, cex.lab=1, cex.text=2,
  cex.main=1.25, adj.alpha=.3)
#Plot for rolling 6-month averages
plot(x=gr1, y="roll", lwd=4, gcol=c("red", "blue"), gband=TRUE, overall=TRUE,
  oband=TRUE, ocol="gray", tcol="green", tgt=4, tpline=c(4,6),
  tpcol="yellow", name=TRUE, cex.axis=1, cex.lab=1, cex.text=2,
  cex.main=1.25, adj.alpha=.3)
}
