% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_emd.R
\name{hanr_emd}
\alias{hanr_emd}
\title{Anomaly detector using EMD}
\usage{
hanr_emd(noise = 0.1, trials = 5)
}
\arguments{
\item{noise}{Numeric. Noise amplitude for CEEMD.}

\item{trials}{Integer. Number of CEEMD trials.}
}
\value{
\code{hanr_emd} object
}
\description{
Empirical Mode Decomposition (CEEMD) to extract intrinsic mode functions and
flag anomalies from high-frequency components. Wraps \code{hht::CEEMD}.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure EMD-based anomaly detector
model <- hanr_emd()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Huang NE, et al. (1998). The empirical mode decomposition and the Hilbert spectrum
for nonlinear and non-stationary time series analysis. Proc. Royal Society A.
}
}
