% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_fft_amoc.R
\name{hanr_fft_amoc}
\alias{hanr_fft_amoc}
\title{Anomaly Detector using FFT with AMOC Cutoff}
\usage{
hanr_fft_amoc()
}
\value{
\code{hanr_fft_amoc} object
}
\description{
This function implements an anomaly detection method that uses the Fast Fourier daltoolbox::transform (FFT)
combined with an automatic frequency cutoff strategy based on the AMOC (At Most One Change)
algorithm. The model analyzes the power spectrum of the time series and detects the optimal
cutoff frequency — the point where the frequency content significantly changes — using
a changepoint detection method from the \code{changepoint} package.

All frequencies below the cutoff are removed from the spectrum, and the inverse FFT reconstructs
a filtered version of the original signal that preserves only high-frequency components.
The resulting residual signal is then analyzed to identify anomalous patterns based on
its distance from the expected behavior.

This function extends the HARBINGER framework and returns an object of class \code{hanr_fft_amoc}.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure FFT+AMOC detector
model <- hanr_fft_amoc()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Inspect detected anomalies
print(detection[detection$event, ])

}
\references{
\itemize{
\item Sobrinho, E. P., Souza, J., Lima, J., Giusti, L., Bezerra, E., Coutinho, R., Baroni, L.,
Pacitti, E., Porto, F., Belloze, K., Ogasawara, E. Fine-Tuning Detection Criteria for
Enhancing Anomaly Detection in Time Series. In: Simpósio Brasileiro de Banco de Dados
(SBBD). SBC, 29 Sep. 2025. doi:10.5753/sbbd.2025.247063
}
}
