/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5SMmodule.h" 
#define H5SM_TESTING    

#include "H5private.h"   
#include "H5ACprivate.h" 
#include "H5Eprivate.h"  
#include "H5Fprivate.h"  
#include "H5SMpkg.h"     

herr_t
H5SM__get_mesg_count_test(H5F_t *f, unsigned type_id, size_t *mesg_count)
{
    H5SM_master_table_t *table     = NULL;    
    herr_t               ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE_TAG(H5AC__SOHM_TAG)

    
    assert(f);
    assert(mesg_count);

    
    if (H5_addr_defined(H5F_SOHM_ADDR(f))) {
        H5SM_index_header_t  *header;      
        H5SM_table_cache_ud_t cache_udata; 
        ssize_t               index_num;   

        
        cache_udata.f = f;

        
        if (NULL == (table = (H5SM_master_table_t *)H5AC_protect(f, H5AC_SOHM_TABLE, H5F_SOHM_ADDR(f),
                                                                 &cache_udata, H5AC__READ_ONLY_FLAG)))
            HGOTO_ERROR(H5E_SOHM, H5E_CANTPROTECT, FAIL, "unable to load SOHM master table");

        
        if (H5SM__get_index(table, type_id, &index_num) < 0)
            HGOTO_ERROR(H5E_SOHM, H5E_CANTGET, FAIL, "unable to check for SOHM index");
        if (index_num < 0)
            HGOTO_ERROR(H5E_SOHM, H5E_NOTFOUND, FAIL, "unable to find correct SOHM index");
        header = &(table->indexes[index_num]);

        
        *mesg_count = header->num_messages;
    } 
    else
        
        *mesg_count = 0;

done:
    
    if (table && H5AC_unprotect(f, H5AC_SOHM_TABLE, H5F_SOHM_ADDR(f), table, H5AC__NO_FLAGS_SET) < 0)
        HDONE_ERROR(H5E_SOHM, H5E_CANTUNPROTECT, FAIL, "unable to close SOHM master table");

    FUNC_LEAVE_NOAPI_TAG(ret_value)
} 
