% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcde.R
\name{plot.cde}
\alias{plot.cde}
\title{Plots conditional densities}
\usage{
\method{plot}{cde}(
  x,
  firstvar = 1,
  mfrow = n2mfrow(dim(x$z)[firstvar]),
  plot.fn = "stacked",
  x.name,
  margin = NULL,
  ...
)
}
\arguments{
\item{x}{Output from \code{\link[=cde]{cde()}}.}

\item{firstvar}{If there is more than one conditioning variable,
\code{firstvar} specifies which variable to fix first.}

\item{mfrow}{If there is more than one conditioning variable, \code{mfrow}
is passed to \code{\link[graphics:par]{graphics::par()}} before plotting.}

\item{plot.fn}{Specifies which plotting function to use: "stacked" results
in stacked conditional densities and "hdr" results in highest density
regions.}

\item{x.name}{Name of x (conditioning) variable for use on x-axis.}

\item{margin}{Marginal density of conditioning variable. If present, only
conditional densities corresponding to non-negligible marginal densities
will be plotted.}

\item{\dots}{Additional arguments to plot.}
}
\value{
If \code{plot.fn=="stacked"} and there is only one conditioning
variable, the function returns the output from
\code{\link[graphics:persp]{graphics::persp()}}.  If \code{plot.fn=="hdr"} and there is only
one conditioning variable, the function returns the output from
\code{\link[=hdr.cde]{hdr.cde()}}. When there is more than one conditioning variable,
nothing is returned.
}
\description{
Produces stacked density plots or highest density region plots for a
univariate density conditional on one covariate.
}
\examples{
faithful.cde <- cde(faithful$waiting, faithful$eruptions,
  x.name = "Waiting time", y.name = "Duration time"
)
plot(faithful.cde)
plot(faithful.cde, plot.fn = "hdr")
}
\references{
Hyndman, R.J., Bashtannyk, D.M. and Grunwald, G.K. (1996)
"Estimating and visualizing conditional densities". \emph{Journal of
Computational and Graphical Statistics}, \strong{5}, 315-336.
}
\seealso{
\code{\link[=hdr.cde]{hdr.cde()}}, \code{\link[=cde]{cde()}}, \code{\link[=hdr]{hdr()}}
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{hplot}
\keyword{smooth}
