% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_plot.R
\name{densityPlot}
\alias{densityPlot}
\title{Create density plot}
\usage{
densityPlot(
  df,
  title = "Density plot",
  colorScheme = c("oasis", "sea", "lava", "custom"),
  useSchemeDefaults = FALSE,
  drawNN = TRUE,
  drawScores = FALSE,
  palette = NULL,
  segColor = "plum1",
  pointSize = 0.8,
  pointColor = "red",
  segType = c("dashed", "solid", "dotted", "dotdash", "longdash", "twodash"),
  segWidth = 0.4,
  legendPos = c("right", "none"),
  nGridPoints = 300,
  expandPerc = 20,
  labelSize = 2.5,
  labelColor = "black",
  labelRepulsion = 1,
  labelPull = 1,
  maxOverlaps = Inf,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{df}{A data frame with at least two columns, representing the \code{x}
and \code{y} coordinates of the points. A score column can also be provided
as the third column. Nearest neighbor information can be provided in the last
column as a character vector with elements selected from the rownames.}

\item{title}{Plot title.}

\item{colorScheme}{Color scheme.}

\item{useSchemeDefaults}{Whether to use the default \code{segColor},
\code{pointColor} and \code{labelColor} for scheme. Ignored
if \code{colorScheme} is set to 'custom'.}

\item{drawNN}{Whether to draw segments linking each point to its nearest
neighbor.}

\item{drawScores}{Whether to render scores on the plot. If set to
\code{TRUE}, the third column of the input data frame will be numeric and
scores will be taken from there.}

\item{palette}{Color palette. Used only if color scheme is set to 'custom'.}

\item{segColor}{Nearest neighbor segment color. Ignored if \code{drawNN} is
set to \code{FALSE}, or if \code{useSchemeDefaults} is \code{TRUE} and
\code{colorScheme} is different from 'custom'.}

\item{pointSize}{Point size.}

\item{pointColor}{Point color. Ignored if \code{useSchemeDefaults}
is \code{TRUE} and \code{colorScheme} is different from 'custom'.}

\item{segType}{Nearest neighbor segment type. Must choose between 'solid',
'dashed', 'dotted','dotdash', 'longdash' and 'twodash'. Ignored if
\code{drawNN} is set to \code{FALSE}.}

\item{segWidth}{Nearest neighbor segment width. Ignored if \code{drawNN} is
set to \code{FALSE}.}

\item{legendPos}{Legend position. Choose between 'right' and 'none'.}

\item{nGridPoints}{Number of grid points in each direction.}

\item{expandPerc}{Percentage by which the grid will be expanded.}

\item{labelSize}{Size of labels of strata elements.}

\item{labelColor}{Label color. Ignored if \code{useSchemeDefaults}
is \code{TRUE} and \code{colorScheme} is different from 'custom'.}

\item{labelRepulsion}{Repulsion strength between labels.}

\item{labelPull}{Attraction strength between a text label
and its data point.}

\item{maxOverlaps}{Maximum overlaps.}

\item{verbose}{Whether output should be verbose.}

\item{...}{Other arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function creates a density plot.
}
\examples{
x <- c(1, 2, 3, 4, 6, 7, 8, 10, 12, 11, 3, 6, 4, 1, 13, 13, 14, 18, 16)
y <- c(1, 3, 1, 4, 3, 2, 8, 2, 1, 11, 8, 8, 10, 14, 13, 11, 11, 12,15)
z <- round(runif(19, 75, 100), 2)
df <- data.frame(x, y, z)
rownames(df) <- paste0('p', rownames(df))
densityPlot(df)

}
