% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_quad_ij_to_icosa_tri}
\alias{hexify_quad_ij_to_icosa_tri}
\title{Convert Quad IJ to Icosa Triangle coordinates}
\usage{
hexify_quad_ij_to_icosa_tri(quad, i, j, resolution, aperture = 3L)
}
\arguments{
\item{quad}{Quad number (0-11), integer or vector}

\item{i}{Cell index along first axis, integer or vector}

\item{j}{Cell index along second axis, integer or vector}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Data frame with columns:
\item{icosa_triangle_face}{Triangle face number (0-19)}
\item{icosa_triangle_x}{X coordinate on triangle face}
\item{icosa_triangle_y}{Y coordinate on triangle face}
}
\description{
Converts Quad IJ coordinates to icosahedral triangle coordinates.
This is useful for understanding where a cell is located on the
icosahedral projection.
}
\details{
Equivalent to 'dggridR' dgQ2DI_to_PROJTRI().
}
\examples{
# Get triangle coordinates for a Quad IJ position
result <- hexify_quad_ij_to_icosa_tri(quad = 1, i = 100, j = 50,
                                       resolution = 10, aperture = 3)
print(result)
}
\seealso{
\code{\link{hexify_icosa_tri_to_quad_ij}} for the inverse,
\code{\link{hexify_cell_to_icosa_tri}} for conversion from cell ID

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
