% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-get_hub.R
\name{get_hub_timezone}
\alias{get_hub_timezone}
\alias{get_hub_model_output_dir}
\alias{get_hub_file_formats}
\alias{get_hub_derived_task_ids}
\title{Get hub configuration fields}
\usage{
get_hub_timezone(hub_path)

get_hub_model_output_dir(hub_path)

get_hub_file_formats(hub_path, round_id = NULL)

get_hub_derived_task_ids(hub_path, round_id = NULL)
}
\arguments{
\item{hub_path}{Either a character string path to a local Modeling Hub directory,
a character string of a URL to a GitHub repository
or an object of class \verb{<SubTreeFileSystem>} created using functions \code{\link[arrow:s3_bucket]{arrow::s3_bucket()}}
or \code{\link[arrow:gs_bucket]{arrow::gs_bucket()}} by providing a string S3 or GCS bucket name or path to a
Modeling Hub directory stored in the cloud.
For more details consult the
\href{https://arrow.apache.org/docs/r/articles/fs.html}{Using cloud storage (S3, GCS)}
in the \code{arrow} package.}

\item{round_id}{Character string. Round identifier. If the round is set to
\code{round_id_from_variable: true}, IDs are values of the task ID defined in the
round's \code{round_id} property of \code{config_tasks}.
Otherwise should match round's \code{round_id} value in config. Ignored if hub
contains only a single round.}
}
\value{
\itemize{
\item \code{get_hub_timezone}: The timezone of the hub
}

\itemize{
\item \code{get_hub_model_output_dir}: The model output directory name
}

\itemize{
\item \code{get_hub_file_formats}: character vector accepted hub or round level
file formats. If \code{round_id} is \code{NULL} or the round does not have a round level
\code{file_format} setting, returns the hub level \code{file_format} setting.
}

\itemize{
\item \code{get_hub_derived_task_ids}: character vector of hub or round level derived
task ID names. If \code{round_id} is \code{NULL} or the round does not have a round level
\code{derived_tasks_ids} setting, returns the hub level \code{derived_tasks_ids} setting.
}
}
\description{
Get hub configuration fields
}
\section{Functions}{
\itemize{
\item \code{get_hub_timezone()}: Get the hub timezone

\item \code{get_hub_model_output_dir()}: Get the model output directory name

\item \code{get_hub_file_formats()}: Get the hub or round level file formats

\item \code{get_hub_derived_task_ids()}: Get the hub or round level \code{derived_tasks_ids}

}}
\examples{
hub_path <- system.file("testhubs", "flusight", package = "hubUtils")
get_hub_timezone(hub_path)
get_hub_model_output_dir(hub_path)
get_hub_file_formats(hub_path)
get_hub_file_formats(hub_path, "2022-12-12")
}
