% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{summary.hydroState.allModels}
\alias{summary.hydroState.allModels}
\title{Summarize all models}
\usage{
\method{summary}{hydroState.allModels}(object, ...)
}
\arguments{
\item{object}{hydroState.allModels object with a list of models from \code{build.all}}

\item{...}{No additional input required}
}
\value{
A data.frame with a summary table of all models and reference models
}
\description{
\code{summary} outputs a summary table of all built hydroState models and allows users to edit the reference models for calibration.
}
\details{
\code{summary}

For every model object in \code{build.all}, there is a reference model for calibration. The reference model is a slightly simpler model with one less parameter. During calibration with \code{fit}, the model performance must exceed the the performance of the reference model else the model is rejected. This function is used to output the \code{summary.table} and adjust the reference models. Afterwards, all models can be re-build with including this \code{summary.table} in the \code{build.all} function.
}
\examples{
# Show summary table of all fitted model details and reference models

all.models.ref.table = summary(all.models.annual.fitted.407211)

}
\keyword{all}
\keyword{hydroState}
\keyword{models}
\keyword{summary}
