% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ib.R
\name{ibControl}
\alias{ibControl}
\title{Auxiliary for controlling IB}
\usage{
ibControl(
  tol = 1e-05,
  maxit = 25,
  verbose = FALSE,
  seed = 123L,
  H = 1L,
  constraint = TRUE,
  early_stop = FALSE,
  cens = FALSE,
  right = NULL,
  left = NULL,
  mis = FALSE,
  prop = NULL,
  out = FALSE,
  eps = NULL,
  G = NULL,
  func = function(x) rowMeans(x, na.rm = T),
  sim = NULL
)
}
\arguments{
\item{tol}{positive convergence tolerance \eqn{\epsilon}.
The \code{\link{ib}} procedure converges when
\eqn{||\hat{\theta}^{k+1}-\hat{\theta}^k||_2/p<\epsilon}{||\theta^{k+1}-\theta^k||_2/p<\epsilon},
where \eqn{p} is the dimension of \eqn{\theta}.}

\item{maxit}{\code{integer} representing the maximal number of iterations.}

\item{verbose}{if \code{TRUE}, it prints some output in the console
at each iteration.}

\item{seed}{\code{integer} to set the seed (see \code{\link[base]{Random}}).}

\item{H}{\code{integer} representing the number of bootstrap estimates
(see \code{\link{ib}}).}

\item{constraint}{if \code{TRUE} (default), constraint for \code{extra_param}
is used in the iterative procedure (see 'Details' of \code{\link{ib}}).}

\item{early_stop}{if \code{TRUE} (default is \code{FALSE}), the iterative
procedure stops as soon as there is no improvment in the minimization of
the objective function (see 'Details' of \code{\link{ib}}).}

\item{cens}{if \code{TRUE} the simulated responses are censored according to
\code{left} and \code{right} values.}

\item{right}{\code{double} for right-censoring (only used if \code{cens=TRUE}).}

\item{left}{\code{double} for left-censoring (only used if \code{cens=TRUE}).}

\item{mis}{if \code{TRUE} the simulated responses have missing data at random.}

\item{prop}{\code{double} between 0 and 1 representing the proportion of
missing data (only used if \code{mis=TRUE}).}

\item{out}{if \code{TRUE} the simulated responses are also generated with a
contamination mechanism.}

\item{eps}{\code{double} between 0 and 1 representing the proportion of
outliers in the data (only used if \code{out=TRUE}).}

\item{G}{a \code{function} to generate outliers. It takes only
a sample size as argument.}

\item{func}{a \code{function} to reduce the \code{H} bootstrap estimates (rowwise).
By default, the average is computed. The user can supply a function.
One could imagine using other function such as the median or a trimmed mean.}

\item{sim}{a user-defined function for simulating responses (see 'Details')}
}
\value{
a list with components named as the arguments.
}
\description{
Auxiliary function for \code{\link{ib}} bias correction.
}
\details{
\code{sim} allows the user to provide its own function for generating
responses. Currently it is only supported for generalized linear models with
the prototype `fun(object, control, extra_param, ...)` (see \code{\link{ib}}).
}
\seealso{
\code{\link{ib}}, the iterative procedure for bias correction.
}
