% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.artifact.R
\name{check.artifact}
\alias{check.artifact}
\title{Check an Artifact File Entry}
\usage{
check.artifact(artifact, check.metadata = TRUE, check.type = TRUE,
  quiet = FALSE)
}
\arguments{
\item{artifact}{an artifact object made using \code{artifact}.}

\item{check.metadata}{logical, should the metadata be checked against
the ICES Vocabulary database?}

\item{check.type}{logical, should type specific artifact checks be run?}

\item{quiet}{logical, should the function be quiet?}
}
\description{
Validate an artifact as an export from a TAF repository.
}
\examples{
\dontrun{
sag_file <- system.file("SAG", "sol_27_4.xml", package = "icesTAF")
sag <- artifact(sag_file, type = "SAG", check = FALSE)
check.artifact(sag)
}

}
