% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable-getListing.R
\name{getListing}
\alias{getListing}
\title{Format or create flextable for listings.}
\usage{
getListing(
  data,
  ft,
  border = TRUE,
  highlight = integer(),
  bgVar = NULL,
  fontname = switch(style, report = "Times", presentation = "Tahoma"),
  fontsize = switch(style, report = 8, presentation = 10),
  landscape = (style == "presentation"),
  style = "report",
  margin = 1,
  adjustWidth = TRUE,
  colorTable = getColorPaletteTable(style = style),
  align = TRUE,
  title = NULL,
  pageDim = NULL,
  includeRownames = TRUE
)
}
\arguments{
\item{data}{data.frame with data used in table.}

\item{ft}{Corresponding \code{\link[flextable]{flextable}}.}

\item{border}{Logical, if TRUE add a border.}

\item{highlight}{Integer vector with index(ices) of column(s) to highlight
(only applies for \code{style}: 'presentation').
0 for rownames (if present).
Colors for:
\itemize{
\item{highlighted columns is specified in \code{colorTable["headerBackgroundHighlight"]}}
\item{non highlighted columns is specified in \code{colorTable["headerBackground"]}}
}}

\item{bgVar}{String with the column of the \code{data} used for
alternating the body background colors of the table.}

\item{fontname}{String with font name, 'Times' by default.}

\item{fontsize}{Integer with font size, 8 by default.}

\item{landscape}{Logical, if TRUE the table is presented in landscape
format. \cr
By default: TRUE for \code{style}: 'report',
FALSE for \code{style}: 'presentation'.}

\item{style}{String with table style, either 'report' (by default, a4 format) 
or 'presentation'}

\item{margin}{Margin in the document in inches, 1 by default.}

\item{adjustWidth}{Logical, if TRUE adjust column widths,
to comply to specification of \code{landscape},
\code{margin} and \code{pageDim}
(only set to \code{FALSE} if e.g. table dimensions 
are pre-set with the specified \code{ft}).}

\item{colorTable}{Named character vector with color for the table,
see output of \code{\link{getColorPaletteTable}} for required elements.}

\item{align}{Logical, if TRUE (by default), 
default alignment is set ('center' in all table).}

\item{title}{Character vector with title(s) for the table.
Set to NULL (by default) if no title should be included.
Only available if \code{ft} is not specified.}

\item{pageDim}{(optional) Numeric vector of length 2 with 
page width and height in inches in portrait format,
in case page dimensions differ from the default
implemented report/presentation.
These dimensions should include the margins.}

\item{includeRownames}{Logical, if TRUE (by default)
rownames are included in the \code{\link[flextable]{flextable}} object.}
}
\value{
\code{\link[flextable]{flextable}} with style.
}
\description{
Flextable version >= 0.4.7 and pandoc >= 2.4
is required to included such table in a Rmarkdown document.
}
\examples{
# style: report or presentation
getListing(data = head(mtcars), style = "report")
getListing(data = head(mtcars), style = "presentation")
# remove rownames (included by default)
getListing(data = head(mtcars), style = "presentation", includeRownames = FALSE)
# highlight:
#  all columns
getListing(data = head(mtcars), style = "presentation", highlight = seq_along(mtcars))
# rownames
getListing(data = head(mtcars), style = "presentation", highlight = 0)
# specific columns
getListing(data = head(mtcars), style = "presentation", highlight = c(2, 4))
}
