% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_median_dayslost.R
\name{calc_median_dayslost}
\alias{calc_median_dayslost}
\title{Calculate the median days lost}
\usage{
calc_median_dayslost(injd, by = NULL, overall = TRUE)
}
\arguments{
\item{injd}{\code{injd} \strong{S3} object (see
\code{\link[=prepare_all]{prepare_all()}}).}

\item{by}{Character specifying the name of the column according to which
compute summary statistics. It should refer to a (categorical) variable
that describes a grouping factor (e.g. "type of case or injury", "injury
location", "sports club"). Optional, defaults to \code{NULL}.}

\item{overall}{Logical, whether to calculate overall (for all the cohort) or
athlete-wise summary statistic (i.e. number of cases per cohort of per
athlete). Defaults to \code{TRUE}.}
}
\value{
The median of the days lost. Either a numeric value (if overall
\code{TRUE}) or a data frame indicating the median days lost per athlete.
}
\description{
Calculate the median of the days lost due to a sports-related health problem
(e.g. disease, injury).
}
\examples{
calc_median_dayslost(injd)
calc_median_dayslost(injd, overall = FALSE)
calc_median_dayslost(injd, by = "injury_type")
}
