% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intsurv-package.R
\docType{package}
\name{intsurv}
\alias{intsurv}
\alias{intsurv-package}
\title{Integrative Survival Modeling}
\description{
The package \pkg{intsurv} provides implementations of
}
\details{
\itemize{

\item integrative Cox model with uncertain event times (Wang et al., 2020)

\item Cox cure rate model with uncertain event status (Wang et al., 2023)

}

It also contains other survival analysis routines, including regular Cox
cure rate model, regularized Cox cure rate model with elastic net penalty,
and weighted concordance index.
}
\references{
Wang, W., Aseltine, R. H., Chen, K., & Yan, J. (2020). Integrative Survival
Analysis with Uncertain Event Times in Application to A Suicide Risk
Study. \emph{Annals of Applied Statistics}, 14(1), 51--73.

Wang, W., Luo, C., Aseltine, R. H., Wang, F., Yan, J., & Chen,
K. (2023). Survival Modeling of Suicide Risk with Rare and Uncertain
Diagnoses. \emph{Statistics in Biosciences}, 17(1), 1--27.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://wwenjie.org/intsurv}
  \item \url{https://github.com/wenjie2wang/intsurv}
  \item Report bugs at \url{https://github.com/wenjie2wang/intsurv/issues}
}

}
\author{
\strong{Maintainer}: Wenjie Wang \email{wang@wwenjie.org} (\href{https://orcid.org/0000-0003-0363-3180}{ORCID})

Other contributors:
\itemize{
  \item Kun Chen (\href{https://orcid.org/0000-0003-3579-5467}{ORCID}) [thesis advisor]
  \item Jun Yan (\href{https://orcid.org/0000-0003-4401-7296}{ORCID}) [thesis advisor]
}

}
\keyword{internal}
