% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.R
\name{partial_eigen}
\alias{partial_eigen}
\title{Find a few approximate largest eigenvalues and corresponding eigenvectors of a symmetric matrix.}
\usage{
partial_eigen(x, n = 5, symmetric = TRUE, ...)
}
\arguments{
\item{x}{numeric real-valued dense or sparse matrix.}

\item{n}{number of largest eigenvalues and corresponding eigenvectors to compute.}

\item{symmetric}{\code{TRUE} indicates \code{x} is a symmetric matrix (the default);
specify \code{symmetric=FALSE} to compute the largest eigenvalues and corresponding
eigenvectors of \code{t(x) \%*\% x} instead.}

\item{...}{optional additional parameters passed to the \code{irlba} function.}
}
\value{
Returns a list with entries:
\item{values}{n approximate largest eigenvalues}
\item{vectors}{n approximate corresponding eigenvectors}
}
\description{
Use \code{partial_eigen} to estimate a subset of the largest (most positive)
eigenvalues and corresponding eigenvectors of a symmetric dense or sparse
real-valued matrix.
}
\note{
Specify \code{symmetric=FALSE} to compute the largest \code{n} eigenvalues
and corresponding eigenvectors of the symmetric matrix cross-product
\code{t(x) \%*\% x}.

This function uses the \code{irlba} function under the hood. See \code{?irlba}
for description of additional options, especially the \code{tol} parameter.

See the RSpectra package https://cran.r-project.org/package=RSpectra for more comprehensive
partial eigenvalue decomposition.
}
\examples{
set.seed(1)
# Construct a symmetric matrix with some positive and negative eigenvalues:
V <- qr.Q(qr(matrix(runif(100), nrow=10)))
x <- V \%*\% diag(c(10, -9, 8, -7, 6, -5, 4, -3, 2, -1)) \%*\% t(V)
partial_eigen(x, 3)$values

# Compare with eigen
eigen(x)$values[1:3]

# Use symmetric=FALSE to compute the eigenvalues of t(x) \%*\% x for general
# matrices x:
x <- matrix(rnorm(100), 10)
partial_eigen(x, 3, symmetric=FALSE)$values
eigen(crossprod(x))$values

}
\references{
Augmented Implicitly Restarted Lanczos Bidiagonalization Methods, J. Baglama and L. Reichel, SIAM J. Sci. Comput. 2005.
}
\seealso{
\code{\link{eigen}}, \code{\link{irlba}}
}
