% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_vars_omv.R
\name{label_vars_omv}
\alias{label_vars_omv}
\title{Label columns / variables in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})}
\usage{
label_vars_omv(
  dtaInp = NULL,
  fleOut = "",
  varLbl = NULL,
  psvAnl = FALSE,
  usePkg = c("foreign", "haven"),
  selSet = "",
  ...
)
}
\arguments{
\item{dtaInp}{Either a data frame or the name of a data file to be read (including the path, if required; "FILENAME.ext"; default: NULL); files can be of
any supported file type, see Details below}

\item{fleOut}{Name of the data file to be written (including the path, if required; "FILE_OUT.omv"; default: ""); if empty, the resulting data frame is
returned instead}

\item{varLbl}{Variable (default: NULL) containing either a character (a file name; the file must contain two columns one with variable names, the other with
the labels), a data frame (one column the variable names, the other the labels), or a character vector (with the same length as the data set,
containing the variable labels). See Details for more information.}

\item{psvAnl}{Whether analyses that are contained in the input file shall be transferred to the output file (default: FALSE)}

\item{usePkg}{Name of the package: "foreign" or "haven" that shall be used to read SPSS, Stata and SAS files; "foreign" is the default (it comes with
base R), but "haven" is newer and more comprehensive}

\item{selSet}{Name of the data set that is to be selected from the workspace (only applies when reading .RData-files)}

\item{...}{Additional arguments passed on to methods; see Details below}
}
\value{
a data frame (only returned if \code{fleOut} is empty) where the order of variables / columns of the input data set is re-arranged
}
\description{
Label columns / variables in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})
}
\details{
\itemize{
\item \code{varLbl} can be either (1) a character with a file name to read (the file must contain to columns, one with the variable names, the other with the
variable labels); (2) a data frame with two columns (one with the variable names, the other with the variable labels), or (3) a character vector
containing the variable labels (with a length equal to the number of variables in the input data set).
\item The ellipsis-parameter (\code{...}) can be used to submit arguments / parameters to the functions that are used for reading and writing the data. By clicking
on the respective function under “See also”, you can get a more detailed overview over which parameters each of those functions take. The functions are:
\code{read_omv} and \code{write_omv} (for jamovi-files), \code{read.table} (for CSV / TSV files; using similar defaults as \code{read.csv} for CSV and \code{read.delim} for TSV
which both are based upon \code{read.table}), \code{load} (for .RData-files), \code{readRDS} (for .rds-files), \code{read_sav} (needs the R-package \code{haven}) or \code{read.spss}
(needs the R-package \code{foreign}) for SPSS-files, \code{read_dta} (\code{haven}) / \code{read.dta} (\code{foreign}) for Stata-files, \code{read_sas} (\code{haven}) for SAS-data-files,
and \code{read_xpt} (\code{haven}) / \code{read.xport} (\code{foreign}) for SAS-transport-files. If you would like to use \code{haven}, you may need to install it using
\code{install.packages("haven", dep = TRUE)}.
}
}
\examples{
# use one of the data files included in the package, but only the first 28 columns
# (the latter columns contain data for testing calculations, etc.)
nmeInp <- system.file("extdata", "bfi_sample.omv", package = "jmvReadWrite")
dtaInp <- jmvReadWrite::read_omv(nmeInp)[1:28]
nmeOut <- tempfile(fileext = ".omv")
# in the original file, the variable labels – attr(*, "jmv-desc") - are empty
lapply(dtaInp, attr, "jmv-desc")
# the definition of the variable labels can be read from a file with two columns,
# the first containing the variable name, the second the variable labels
# you can easily create such a file in Excel and save it as CSV
# if your CSV contains column names (e.g., varNme and varLbl) in the first row are they ignored
lblFle <- system.file("extdata", "label_example.csv", package = "jmvReadWrite")
lblDtF <- utils::read.csv(lblFle, header = FALSE)
str(lblDtF)

# there are three options to give the varLbl parameter:
# (1) as file name, ...
jmvReadWrite::label_vars_omv(dtaInp = dtaInp, fleOut = nmeOut, varLbl = lblFle)
lapply(jmvReadWrite::read_omv(nmeOut), attr, "jmv-desc")
unlink(nmeOut)

# (2) as data frame (using lblDtF from above), or ...
jmvReadWrite::label_vars_omv(dtaInp = dtaInp, fleOut = nmeOut, varLbl = lblDtF)
lapply(jmvReadWrite::read_omv(nmeOut), attr, "jmv-desc")
unlink(nmeOut)

# (3) as character vector (with the same length as there are columns in the input data set)
lblChr <- lblDtF[[2]]
head(lblChr)
jmvReadWrite::label_vars_omv(dtaInp = dtaInp, fleOut = nmeOut, varLbl = lblChr)
lapply(jmvReadWrite::read_omv(nmeOut), attr, "jmv-desc")
unlink(nmeOut)


}
\seealso{
\code{label_vars_omv} internally uses the following functions for reading and writing data files in different formats: \code{\link[=read_omv]{read_omv()}} and
\code{\link[=write_omv]{write_omv()}} for jamovi-files, \code{\link[utils:read.table]{utils::read.table()}} for CSV / TSV files, \code{\link[=load]{load()}} for reading .RData-files, \code{\link[=readRDS]{readRDS()}} for .rds-files,
\code{\link[haven:read_spss]{haven::read_sav()}} or \code{\link[foreign:read.spss]{foreign::read.spss()}} for SPSS-files, \code{\link[haven:read_dta]{haven::read_dta()}} or \code{\link[foreign:read.dta]{foreign::read.dta()}} for Stata-files, \code{\link[haven:read_sas]{haven::read_sas()}} for
SAS-data-files, and \code{\link[haven:read_xpt]{haven::read_xpt()}} or \code{\link[foreign:read.xport]{foreign::read.xport()}} for SAS-transport-files.
}
