% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-image.R
\name{op_image_elastic_transform}
\alias{op_image_elastic_transform}
\title{Applies elastic deformation to the image(s).}
\usage{
op_image_elastic_transform(
  images,
  alpha = 20,
  sigma = 5,
  interpolation = "bilinear",
  fill_mode = "reflect",
  fill_value = 0,
  seed = NULL,
  data_format = NULL
)
}
\arguments{
\item{images}{Input image or batch of images. Must be 3D or 4D.}

\item{alpha}{Scaling factor that controls the intensity of the deformation.}

\item{sigma}{Standard deviation of the Gaussian filter used for
smoothing the displacement fields.}

\item{interpolation}{Interpolation method. Available methods are \code{"nearest"},
and \code{"bilinear"}. Defaults to \code{"bilinear"}.}

\item{fill_mode}{Points outside the boundaries of the input are filled
according to the given mode. Available methods are \code{"constant"},
\code{"nearest"}, \code{"wrap"} and \code{"reflect"}. Defaults to \code{"reflect"}.
\itemize{
\item \code{"reflect"}: \verb{(d c b a | a b c d | d c b a)}
The input is extended by reflecting about the edge of the last
pixel.
\item \code{"constant"}: \verb{(k k k k | a b c d | k k k k)}
The input is extended by filling all values beyond
the edge with the same constant value \code{k} specified by
\code{fill_value}.
\item \code{"wrap"}: \verb{(a b c d | a b c d | a b c d)}
The input is extended by wrapping around to the opposite edge.
\item \code{"nearest"}: \verb{(a a a a | a b c d | d d d d)}
The input is extended by the nearest pixel.
}}

\item{fill_value}{Value used for points outside the boundaries of the input if
\code{fill_mode="constant"}. Defaults to \code{0}.}

\item{seed}{Optional integer seed for the random number generator.}

\item{data_format}{A string specifying the data format of the input tensor.
It can be either \code{"channels_last"} or \code{"channels_first"}.
\code{"channels_last"} corresponds to inputs with shape
\verb{(batch, height, width, channels)}, while \code{"channels_first"}
corresponds to inputs with shape \verb{(batch, channels, height, width)}.
If not specified, the value will default to
\code{keras.config.image_data_format}.}
}
\value{
Transformed image or batch of images with elastic deformation.
}
\description{
Apply random elastic deformation to 3D or 4D image tensors.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- random_uniform(c(2, 64, 80, 3))  # batch of 2 RGB images
y <- op_image_elastic_transform(x)
op_shape(y)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## shape(2, 64, 80, 3)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- random_uniform(c(64, 80, 3))  # single RGB image
y <- op_image_elastic_transform(x)
op_shape(y)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## shape(64, 80, 3)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- random_uniform(c(2, 3, 64, 80))  # batch of 2 RGB images
y <- op_image_elastic_transform(
  x,
  data_format = "channels_first",
  seed = 123
)
op_shape(y)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## shape(2, 3, 64, 80)

}\if{html}{\out{</div>}}
}

