% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scheme.R
\name{plot_scheme}
\alias{plot_scheme}
\title{Plot Color Scheme}
\usage{
plot_scheme(x, colours = FALSE, names = FALSE, size = 1)
}
\arguments{
\item{x}{A \code{\link{character}} vector of colors.}

\item{colours}{A \code{\link{logical}} scalar: should the hexadecimal representation of
the colors be displayed?}

\item{names}{A \code{\link{logical}} scalar: should the name of the colors be
displayed?}

\item{size}{A \code{\link{numeric}} value giving the amount by which plotting text
should be magnified relative to the default. Works the same as \code{cex}
parameter of \code{\link[graphics:par]{graphics::par()}}.}
}
\value{
\code{plot_scheme()} is called for its side-effects: it results in a graphic
being displayed (invisibly returns \code{x}).
}
\description{
Shows colors in a plot.
}
\examples{
plot(colour("bright")(7))
plot(colour("smooth rainbow")(256))

## Plot colour schemes
plot_scheme(colour("bright")(7))
plot_scheme(colour("sunset")(11))
plot_scheme(colour("YlOrBr")(9))
plot_scheme(colour("discrete rainbow")(14))

## Plot diagnostic maps
plot_map(colour("bright")(7))
plot_map(colour("sunset")(11))
plot_map(colour("YlOrBr")(9))
plot_map(colour("discrete rainbow")(14))

## Plot diagnostic images
plot_tiles(colour("discrete rainbow")(14), n = 256)
plot_tiles(colour("discrete rainbow")(23), n = 256)
plot_tiles(colour("smooth rainbow")(256), n = 256)
}
\seealso{
Other diagnostic tools: 
\code{\link{change}()},
\code{\link{compare}()},
\code{\link{plot.color_scheme}()},
\code{\link{plot_map}()},
\code{\link{plot_scheme_colourblind}()},
\code{\link{plot_tiles}()}
}
\author{
N. Frerebeau
}
\concept{diagnostic tools}
