% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.legend.R
\name{pedigree.legend}
\alias{pedigree.legend}
\title{plot a legend for a pedigree}
\usage{
pedigree.legend(
  ped,
  labels = dimnames(ped$affected)[[2]],
  edges = 200,
  radius = NULL,
  location = "bottomright",
  new = TRUE,
  density = c(-1, 35, 65, 20),
  angle = c(90, 65, 40, 0),
  ...
)
}
\arguments{
\item{ped}{Pedigree data frame with ped (pedigree id), id (id of individual),
father (id of father), mother (id of mother), sex, affected (affection status), 
and avail (DNA availability).}

\item{labels}{names for the affected indicators}

\item{edges}{Number of edges for each polygon. Higher numbers give better
resolution for the circle}

\item{radius}{radius (inches) of the circle}

\item{location}{similar to how the location of a base-R legend is given,
used only if new=TRUE.  A character string indicating which of the four corners
to plot the legend, given by "bottomright", "bottomleft", "topleft", or "topright".}

\item{new}{Logical. If TRUE, plot the legend on the current plot. Otherwise, plot
on a separate plot.}

\item{density}{Density of lines shaded in sections of the circle. These match the
density settings for the plot.pedigree function.}

\item{angle}{The angle at which lines are shaded in sections of the circle. These
match the angles for the plot.pedigree function.}

\item{...}{optional parameters for the plot function that apply to text}
}
\description{
circular legend for a pedigree as a key to the affection statuses
}
\examples{
\dontrun{
data(sample.ped)
fam1 <- sample.ped[sample.ped$ped==1,]
ped1 <- with(fam1, pedigree(id, father, mother, sex,
             affected=cbind(avail,affected)))
plot(ped1)
pedigree.legend(ped1, location="bottomright", radius=.8)
pedigree.legend(ped1, location="topleft", radius=.6, cex=1.2)
pedigree.legend(ped1, new=FALSE)
}
}
\seealso{
\code{\link{pedigree}}, \code{\link{plot.pedigree}}
}
\author{
Jason Sinnwell
}
