% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simu_kldiv}
\alias{simu_kldiv}
\title{Kullback-Leibler divergence via Monte Carlo}
\usage{
simu_kldiv(x, b, kernel, model, B = 10000L, nrep = 10L)
}
\arguments{
\item{x}{a cube of dimension \code{d} by \code{d} by \code{n} containing the sample matrices which define the kernel matrix estimator}

\item{b}{positive double, bandwidth parameter}

\item{model}{integer between 1 and 6 indicating the simulation scenario}

\item{B}{number of Monte Carlo replications, default to 10K}
}
\value{
a vector of length 2 containing the mean and the standard deviation of the estimator.
}
\description{
Given a target density and a kernel estimator, evaluate the
Kullback-Leibler divergence by Monte Carlo integration by simulating draws from the corresponding model.
}
\keyword{internal}
