% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{formatColumn}
\alias{formatColumn}
\title{Format Columns for Print}
\usage{
formatColumn(column, colName)
}
\arguments{
\item{column}{A vector representing a column from a data frame.}

\item{colName}{A string indicating the name of the column, which determines
the formatting rules to be applied.}
}
\value{
A vector with the same length as `column`, where each element has been
  formatted according to the column-specific rules.
}
\description{
This internal helper function is used to format the columns of a data frame
for printing, specifically for use within the `print.anova.lcc` function. It
applies special formatting rules based on the column name, such as rounding
and special handling of small p-values.
}
\details{
The function specifically handles the following columns:
  - "p-value": Rounds the values to four decimal places, and represents
    values less than 0.0001 as "<.0001".
  - "AIC", "BIC", "logLik", "L.Ratio": Applies `zapsmall` for formatting.
  Other columns are returned without changes.
}
\examples{
data <- data.frame(
  pvalue = c(0.00005, 0.0234, 0.5),
  AIC = c(123.4567, 234.5678, 345.6789)
)
data$pvalue <- formatColumn(data$pvalue, "p-value")
data$AIC <- formatColumn(data$AIC, "AIC")

}
