% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{setView}
\alias{setView}
\alias{flyTo}
\alias{fitBounds}
\alias{flyToBounds}
\alias{setMaxBounds}
\alias{clearBounds}
\title{Methods to manipulate the map widget}
\usage{
setView(map, lng, lat, zoom, options = list())

flyTo(map, lng, lat, zoom, options = list())

fitBounds(map, lng1, lat1, lng2, lat2, options = list())

flyToBounds(map, lng1, lat1, lng2, lat2, options = list())

setMaxBounds(map, lng1, lat1, lng2, lat2)

clearBounds(map)
}
\arguments{
\item{map}{a map widget object created from \code{\link[=leaflet]{leaflet()}}}

\item{lng}{The longitude of the map center}

\item{lat}{The latitude of the map center}

\item{zoom}{the zoom level}

\item{options}{a list of zoom/pan options (see
\url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#zoom/pan-options})}

\item{lng1, lat1, lng2, lat2}{the coordinates of the map bounds}
}
\value{
The modified map widget.
}
\description{
A series of methods to manipulate the map.
}
\section{Functions}{
\itemize{
\item \code{setView()}: Set the view of the map (center and zoom level)

\item \code{flyTo()}: Flys to a given location/zoom-level using smooth pan-zoom.

\item \code{fitBounds()}: Set the bounds of a map

\item \code{flyToBounds()}: Flys to given bound using smooth pan/zoom.

\item \code{setMaxBounds()}: Restricts the map view to the given bounds

\item \code{clearBounds()}: Clear the bounds of a map, and the bounds will be
automatically determined from latitudes and longitudes of the map elements
if available (otherwise the full world view is used)

}}
\examples{
\donttest{m <- leaflet() \%>\% addTiles() \%>\% setView(-71.0382679, 42.3489054, zoom = 18)
m  # the RStudio 'headquarter'
m \%>\% fitBounds(-72, 40, -70, 43)
m \%>\% clearBounds()  # world view
}
}
\references{
\url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#map-methods-for-modifying-map-state}
}
