% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{leakr_summarise}
\alias{leakr_summarise}
\title{Enhanced summarise with better formatting}
\usage{
leakr_summarise(
  report,
  top_n = 10,
  show_config = FALSE,
  config = NULL,
  audit_data = NULL,
  detectors = NULL,
  libname = NULL,
  pkgname = NULL
)
}
\arguments{
\item{report}{A \code{leakr_report} object from \code{leakr_audit()}.}

\item{top_n}{Maximum number of issues to display in the summary. Defaults to 10.}

\item{show_config}{Whether to display the configuration details used for the audit. Defaults to \code{FALSE}.}

\item{config}{(Optional) A configuration list. This argument is not used directly in the function,
but is referenced in the report metadata. Defaults to \code{NULL}.}

\item{audit_data}{(Optional) The data used for auditing. This argument is not used directly in the function,
but is part of the report metadata. Defaults to \code{NULL}.}

\item{detectors}{(Optional) A vector of detectors used for the audit. This argument is not used directly in
the function but is part of the report metadata. Defaults to \code{NULL}.}

\item{libname}{(Optional) The name of the library. This is included for internal package functionality.}

\item{pkgname}{(Optional) The name of the package. This is included for internal package functionality.}
}
\value{
An invisible \code{data.frame} summarizing the top \code{n} issues detected.
}
\description{
This function provides a formatted summary of the leakage audit report. It displays
a summary of the leakage issues, including the severity and top issues detected.
Optionally, it can also display configuration details used for the audit.
}
\examples{
\donttest{
# Create and summarise a report
report <- leakr_audit(iris, target = "Species")
leakr_summarise(report, top_n = 5)
}

}
