% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{prepare_audit_data}
\alias{prepare_audit_data}
\title{Enhanced data preparation with robust preprocessing}
\usage{
prepare_audit_data(data, target, split, id, config)
}
\arguments{
\item{data}{A data frame containing the dataset to be audited.}

\item{target}{The name of the target variable (optional). Used for stratified sampling if provided.}

\item{split}{A vector or a column name specifying the data split (e.g., training/test split).}

\item{id}{The unique identifier column for the dataset (optional).}

\item{config}{A list of configuration settings, including sample size and other audit parameters.}
}
\value{
A list of class \code{audit_data} containing preprocessed data along with metadata, such as:
\itemize{
\item \code{data}: The processed data.
\item \code{target}: The target variable name.
\item \code{split}: The split vector or column name.
\item \code{n_rows}: The number of rows in the data.
\item \code{n_cols}: The number of columns in the data.
\item \code{was_sampled}: A logical indicating whether sampling was performed.
}
}
\description{
This function performs robust data preprocessing and prepares the data for leakage detection.
It handles intelligent sampling, adjusts for the presence of a target variable, and structures
the data for further audit and analysis.
}
\examples{
\dontrun{
audit_data <- prepare_audit_data(data, target = "target_column",
                                 split = "train_test_split",
                                 id = "id_column",
                                 config = list(sample_size = 50000))
}

}
\keyword{internal}
