# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

#' lightsf - Collection of georeferenced and spatial datasets from different domains.
#'
#' \if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}
#'
#' Collection of georeferenced and spatial datasets from different domains.
#'
#' @name lightsf
#' @aliases lightsf-package
#' @title lightsf: Collection of georeferenced and spatial datasets from different domains
#' @description {
#' Provides a diverse collection of georeferenced and spatial datasets from different domains including urban studies, housing markets, environmental monitoring, transportation, and socio-economic indicators. The package consolidates datasets from multiple open sources such as Kaggle, chopin, spData, adespatial, and bivariateLeaflet. It is designed for researchers, analysts, and educators interested in spatial analysis, geostatistics, and geographic data visualization.  The datasets include point patterns, polygons, socio-economic data frames, and network-like structures, allowing flexible exploration of geospatial phenomena.
#' }
#' @seealso {
#' Useful links:
#' \itemize{
#'   \item \url{https://github.com/roming20/lightsf}
#' }
#' }
#' @author {
#' \strong{Maintainer}: Ingrid Romero Pinilla \email{ingridpinilla11@gmail.com}
#' }
'_PACKAGE'

