% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{afcon_poly}
\alias{afcon_poly}
\title{Spatial Patterns of Conflict in Africa (1966–1978)}
\format{
A data frame with 42 observations and 5 variables:
\describe{
  \item{x}{Longitude coordinate of the country centroid (numeric)}
  \item{y}{Latitude coordinate of the country centroid (numeric)}
  \item{totcon}{Total number of conflicts recorded, 1966–1978 (numeric)}
  \item{name}{Name of the country (factor with 42 levels)}
  \item{id}{Numeric country identifier (numeric)}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4.
}
\usage{
data(afcon_poly)
}
\description{
This dataset, `afcon_poly`, is a data frame summarizing spatial patterns of
conflict across 42 African countries between 1966 and 1978. The dataset was
originally used in Anselin (1995) to study spatial autocorrelation in
political conflict. It excludes South West Africa, Spanish Equatorial Africa,
and Spanish Sahara. The dataset includes centroid coordinates, country names,
and the total number of recorded conflicts during this period.
}
\details{
The dataset consists of 42 observations (countries) and 5 variables.

The dataset name has been kept as `afcon_poly` to avoid confusion with other
datasets in the R ecosystem. This naming convention helps distinguish this
dataset as part of the `lightsf` package and assists users in identifying its
specific characteristics. The original content has not been modified in any
way.
}
\references{
Anselin, L. (1995). Local Indicators of Spatial Association—LISA.
*Geographical Analysis*, 27(2), 93–115.
}
