% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{auckland_poly}
\alias{auckland_poly}
\title{Infant Mortality in Auckland, New Zealand (1977–1985)}
\format{
A data frame with 167 observations and 4 variables:
\describe{
  \item{Easting}{Easting coordinate (numeric)}
  \item{Northing}{Northing coordinate (numeric)}
  \item{Deaths.1977.85}{Number of infant deaths between 1977 and 1985 (numeric)}
  \item{Under.5.1981}{Population under age 5 in 1981 (numeric)}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4.
}
\usage{
data(auckland_poly)
}
\description{
This dataset, `auckland_poly`, is a data frame containing information on
infant mortality in census area units (CAUs) of Auckland, New Zealand. The
dataset has 167 rows, each corresponding to a CAU, and 4 columns with
geographic coordinates and mortality-related statistics. It is often used in
spatial epidemiology studies and in demonstrations of spatial analysis
methods.
}
\details{
In addition to the `auckland_poly` data frame, the original source also
provides two related spatial objects: `auckland.nb`, a neighbour list of CAUs
based on contiguity, and `auckpolys`, a polylist object representing polygon
boundaries. These are not included here, but can be generated from the
original dataset using spatial analysis workflows.

The dataset name has been kept as `auckland_poly` to avoid confusion with
other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the `lightsf` package and assists users in identifying
its specific characteristics. The original content has not been modified in
any way.
}
