% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_length_linter.R
\name{line_length_linter}
\alias{line_length_linter}
\title{Line length linter}
\usage{
line_length_linter(length = 80L, ignore_string_bodies = FALSE)
}
\arguments{
\item{length}{Maximum line length allowed. Default is \code{80L} (Hollerith limit).}

\item{ignore_string_bodies}{Logical, default \code{FALSE}. If \code{TRUE}, the contents
of string literals are ignored. The quotes themselves are included, so this
mainly affects wide multiline strings, e.g. SQL queries.}
}
\description{
Check that the line length of both comments and code is less than \code{length}.
}
\examples{
# will produce lints
lint(
  text = strrep("x", 23L),
  linters = line_length_linter(length = 20L)
)

# the trailing ' is counted towards line length, so this still lints
lint(
  text = "'a long single-line string'",
  linters = line_length_linter(length = 15L, ignore_string_bodies = TRUE)
)

lines <- paste(
  "query <- '",
  "  SELECT *",
  "  FROM MyTable",
  "  WHERE profit > 0",
  "'",
  sep = "\n"
)
writeLines(lines)
lint(
  text = lines,
  linters = line_length_linter(length = 10L)
)

# okay
lint(
  text = strrep("x", 21L),
  linters = line_length_linter(length = 40L)
)

lines <- paste(
  "paste(",
  "  'a long',",
  "  'single-line',",
  "  'string'",
  ")",
  sep = "\n"
)
writeLines(lines)
lint(
  text = lines,
  linters = line_length_linter(length = 15L, ignore_string_bodies = TRUE)
)

lines <- paste(
  "query <- '",
  "  SELECT *",
  "  FROM MyTable",
  "  WHERE profit > 0",
  "'",
  sep = "\n"
)
writeLines(lines)
lint(
  text = lines,
  linters = line_length_linter(length = 10L, ignore_string_bodies = TRUE)
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#long-lines}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
